/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.fss;

import cool.scx.Scx;
import cool.scx.annotation.FromBody;
import cool.scx.annotation.FromPath;
import cool.scx.annotation.FromQuery;
import cool.scx.annotation.ScxMapping;
import cool.scx.bo.FileUpload;
import cool.scx.enumeration.HttpMethod;
import cool.scx.exception.HttpRequestException;
import cool.scx.ext.fss.FSSHandler;
import cool.scx.ext.fss.FSSModule;
import cool.scx.vo.Download;
import cool.scx.vo.Image;
import cool.scx.vo.Json;
import cool.scx.vo.Raw;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

@ScxMapping(value="/api/fss")
public class FSSController {
    private final FSSHandler fssHandler;

    public FSSController() {
        FSSModule fssModuleExample = (FSSModule)Scx.findScxModuleInfo(FSSModule.class).baseModuleExample();
        this.fssHandler = (FSSHandler)Scx.beanFactory().getBean(fssModuleExample.fssHandlerClass());
    }

    @ScxMapping(value="/download/:fssObjectID", method={HttpMethod.GET, HttpMethod.HEAD})
    public Download download(@FromPath String fssObjectID) throws HttpRequestException, SQLException {
        return this.fssHandler.download(fssObjectID);
    }

    @ScxMapping(value="/image/:fssObjectID", method={HttpMethod.GET, HttpMethod.HEAD})
    public Image image(@FromPath String fssObjectID, @FromQuery(value="w", required=false) Integer width, @FromQuery(value="h", required=false) Integer height, @FromQuery(value="t", required=false) String type) throws HttpRequestException, SQLException {
        return this.fssHandler.image(fssObjectID, width, height, type);
    }

    @ScxMapping(value="/raw/:fssObjectID", method={HttpMethod.GET, HttpMethod.HEAD})
    public Raw raw(@FromPath String fssObjectID) throws HttpRequestException, SQLException {
        return this.fssHandler.raw(fssObjectID);
    }

    @ScxMapping(value="/upload", method={HttpMethod.POST})
    public Json upload(@FromBody String fileName, @FromBody Long fileSize, @FromBody String fileMD5, @FromBody Integer chunkLength, @FromBody Integer nowChunkIndex, FileUpload fileData) throws Exception {
        return this.fssHandler.upload(fileName, fileSize, fileMD5, chunkLength, nowChunkIndex, fileData);
    }

    @ScxMapping(value="/delete", method={HttpMethod.DELETE})
    public Json delete(@FromBody String fssObjectID) throws SQLException {
        return this.fssHandler.delete(fssObjectID);
    }

    @ScxMapping(value="check-any-file-exists-by-this-md5", method={HttpMethod.POST})
    public Json checkAnyFileExistsByThisMD5(@FromBody String fileName, @FromBody Long fileSize, @FromBody String fileMD5) throws SQLException, IOException {
        return this.fssHandler.checkAnyFileExistsByThisMD5(fileName, fileSize, fileMD5);
    }

    @ScxMapping(value="/list", method={HttpMethod.POST})
    public Json list(@FromBody List<String> fssObjectIDs) throws SQLException {
        return this.fssHandler.list(fssObjectIDs);
    }
}

