/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.cms.directive;

import cool.scx.app.annotation.ScxService;
import cool.scx.app.base.BaseTemplateDirective;
import cool.scx.app.bo.ParamWrapper;
import cool.scx.ext.cms.channel.ChannelService;
import java.sql.SQLException;
import java.util.Map;

@ScxService
public class ChannelListDirective
implements BaseTemplateDirective {
    private final ChannelService channelService;

    public ChannelListDirective(ChannelService channelService) {
        this.channelService = channelService;
    }

    public Object handle(Map<String, Object> params) {
        Integer page;
        ParamWrapper query = new ParamWrapper();
        Object id = params.get("id");
        Object parentID = params.get("parentID");
        Object hasChannelTitleImage = params.get("hasChannelTitleImage");
        Object orderByColumn = params.get("orderByColumn");
        Object sortType = params.get("sortType");
        Integer limit = params.get("limit") != null ? Integer.valueOf(params.get("limit").toString()) : null;
        Integer n = page = params.get("page") != null ? Integer.valueOf(params.get("page").toString()) : null;
        if (id != null) {
            query.EQUAL("id", (Object)Long.valueOf(id.toString()));
        }
        if (parentID != null) {
            query.EQUAL("parentID", (Object)Long.valueOf(parentID.toString()));
        }
        if (hasChannelTitleImage != null) {
            if (Boolean.parseBoolean(hasChannelTitleImage.toString())) {
                query.IS_NOT_NULL("channelTitleImage");
            } else {
                query.IS_NULL("channelTitleImage");
            }
        }
        if (limit != null && limit >= 0) {
            if (page != null && page >= 0) {
                query.SET_PAGINATION(page, limit);
            } else {
                query.SET_PAGINATION(limit);
            }
        }
        if (orderByColumn != null && sortType != null) {
            query.ADD_ORDER_BY(orderByColumn.toString(), sortType.toString());
        }
        try {
            return this.channelService.list(query);
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
            return null;
        }
    }

    public String directiveName() {
        return "channel_list_tag";
    }

    public String variableName() {
        return "channel_list";
    }
}

