/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.app.ScxAppContext;
import cool.scx.app.annotation.FromBody;
import cool.scx.app.annotation.FromPath;
import cool.scx.app.annotation.ScxMapping;
import cool.scx.app.base.BaseModel;
import cool.scx.app.enumeration.HttpMethod;
import cool.scx.app.exception.HttpRequestException;
import cool.scx.app.vo.Json;
import cool.scx.ext.crud.CRUDHandler;
import cool.scx.ext.crud.CRUDListResult;
import cool.scx.ext.crud.CRUDModule;
import cool.scx.ext.crud.CrudWhereBody;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

@ScxMapping(value="api/crud")
public class CRUDController {
    private final CRUDHandler crudHandler;

    public CRUDController() {
        Class<? extends CRUDHandler> crudHandlerClass = ((CRUDModule)ScxAppContext.findScxAppModuleInfo(CRUDModule.class).scxAppModuleExample()).crudHandlerClass();
        this.crudHandler = (CRUDHandler)ScxAppContext.beanFactory().getBean(crudHandlerClass);
    }

    @ScxMapping(value=":modelName/list", method={HttpMethod.POST})
    public Json list(@FromPath String modelName, @FromBody(value="pagination.limit", required=false) Integer limit, @FromBody(value="pagination.page", required=false) Integer page, @FromBody(value="orderBy.orderByColumn", required=false) String orderByColumn, @FromBody(value="orderBy.sortType", required=false) String sortType, @FromBody(value="whereBodyList", required=false) List<CrudWhereBody> whereBodyList) throws HttpRequestException, SQLException {
        CRUDListResult crudListResult = this.crudHandler.list(modelName, limit, page, orderByColumn, sortType, whereBodyList);
        return Json.ok().put("items", crudListResult.list()).put("total", (Object)crudListResult.total());
    }

    @ScxMapping(value=":modelName/:id", method={HttpMethod.GET})
    public Json info(@FromPath String modelName, @FromBody Long id) throws HttpRequestException, SQLException {
        BaseModel info = this.crudHandler.info(modelName, id);
        return Json.ok().put("info", (Object)info);
    }

    @ScxMapping(value=":modelName", method={HttpMethod.POST})
    public Json save(@FromPath String modelName, @FromBody(useAllBody=true) Map<String, Object> entityMap) throws HttpRequestException, SQLException {
        BaseModel savedModel = this.crudHandler.save(modelName, entityMap);
        return Json.ok().put("item", (Object)savedModel);
    }

    @ScxMapping(value=":modelName", method={HttpMethod.PUT})
    public Json update(@FromPath String modelName, @FromBody(useAllBody=true) Map<String, Object> entityMap) throws HttpRequestException, SQLException {
        BaseModel updatedModel = this.crudHandler.update(modelName, entityMap);
        return Json.ok().put("item", (Object)updatedModel);
    }

    @ScxMapping(value=":modelName/:id", method={HttpMethod.DELETE})
    public Json delete(@FromPath String modelName, @FromBody Long id) throws HttpRequestException, SQLException {
        boolean b = this.crudHandler.delete(modelName, id);
        return b ? Json.ok() : Json.fail();
    }

    @ScxMapping(value=":modelName/batch-delete", method={HttpMethod.DELETE})
    public Json batchDelete(@FromPath String modelName, @FromBody long[] deleteIDs) throws HttpRequestException, SQLException {
        long deletedCount = this.crudHandler.batchDelete(modelName, deleteIDs);
        return Json.ok().put("deletedCount", (Object)deletedCount);
    }

    @ScxMapping(value=":modelName/revoke-delete/:id", method={HttpMethod.GET})
    public Json revokeDelete(@FromPath String modelName, @FromBody Long id) throws HttpRequestException, SQLException {
        if (!ScxAppContext.appConfig().tombstone()) {
            return Json.fail((String)"not-used-tombstone");
        }
        boolean b = this.crudHandler.revokeDelete(modelName, id);
        return b ? Json.ok() : Json.fail();
    }

    @ScxMapping(value=":modelName/get-auto-complete/:fieldName", method={HttpMethod.POST})
    public Json getAutoComplete(@FromPath String modelName, @FromBody String fieldName) throws HttpRequestException, SQLException {
        List<Map<String, Object>> fieldList = this.crudHandler.getAutoComplete(modelName, fieldName);
        return Json.ok().put("fields", fieldList);
    }

    @ScxMapping(value=":modelName/check-unique", method={HttpMethod.POST})
    public Json checkUnique(@FromPath String modelName, @FromBody String fieldName, @FromBody Object value, @FromBody(required=false) Long id) throws HttpRequestException, SQLException {
        boolean b = this.crudHandler.checkUnique(modelName, fieldName, value, id);
        return Json.ok().put("isUnique", (Object)b);
    }
}

