package cool.scx.ext.organization;

import cool.scx.app.annotation.ScxService;
import cool.scx.app.base.BaseService;
import cool.scx.app.bo.ParamWrapper;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * <p>CoreDeptService class.</p>
 *
 * @author scx567888
 * @version 1.1.2
 */
@ScxService
public class DeptService extends BaseService<Dept> {

    private final UserDeptService userDeptService;

    /**
     * <p>Constructor for CoreDeptService.</p>
     *
     * @param userDeptService a {@link cool.scx.ext.organization.UserDeptService} object.
     */
    public DeptService(UserDeptService userDeptService) {
        this.userDeptService = userDeptService;
    }

    /**
     * getDeptListByUser
     *
     * @param user a {@link cool.scx.ext.organization.User} object
     * @return a {@link java.util.List} object
     */
    public List<Dept> getDeptListByUser(User user) {
        try {
            var deptIDs = userDeptService.list(new ParamWrapper().EQUAL("userID", user.id))
                    .stream().map(userRole -> userRole.deptID).toList();
            if (deptIDs.size() > 0) {
                return list(new ParamWrapper().IN("id", deptIDs));
            }
        } catch (SQLException sqlException) {
            sqlException.printStackTrace();
        }
        return new ArrayList<>();
    }

    /**
     * saveDeptListWithUserID
     *
     * @param userID  a {@link java.lang.Long} object
     * @param deptIDs a {@link java.lang.String} object
     * @throws SQLException s
     */
    public void saveDeptListWithUserID(Long userID, List<Long> deptIDs) throws SQLException {
        if (deptIDs != null) {
            var idArr = deptIDs.stream().filter(Objects::nonNull).map(id -> {
                        var userDept = new UserDept();
                        userDept.userID = userID;
                        userDept.deptID = id;
                        return userDept;
                    }
            ).collect(Collectors.toList());
            userDeptService.save(idArr);
        }
    }

    /**
     * {@inheritDoc}
     *
     * @param id a {@link java.lang.Long} object
     */
    public void deleteByUserID(Long id) throws SQLException {
        var where = new ParamWrapper().EQUAL("userID", id);
        userDeptService.delete(where);
    }

    /**
     * {@inheritDoc}
     *
     * @param userID a {@link java.lang.Long} object
     * @return a {@link java.util.List} object
     */
    public List<UserDept> findDeptByUserID(Long userID) throws SQLException {
        if (userID != null) {
            var paramWrapper = new ParamWrapper().EQUAL("userID", userID);
            return userDeptService.list(paramWrapper);
        }
        return new ArrayList<>();
    }

    /**
     * <p>getUserDeptByUserIDs.</p>
     *
     * @param userIDs a {@link java.util.List} object
     * @return a {@link java.util.List} object
     */
    public List<UserDept> getUserDeptByUserIDs(List<Long> userIDs) {
        try {
            return userDeptService.list(new ParamWrapper().IN("userID", userIDs));
        } catch (SQLException sqlException) {
            sqlException.printStackTrace();
            return new ArrayList<>();
        }
    }
}
