/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import com.google.common.collect.ArrayListMultimap;
import cool.scx.app.ScxAppContext;
import cool.scx.app.ScxAppModuleInfo;
import cool.scx.app.annotation.NoColumn;
import cool.scx.app.base.BaseModel;
import cool.scx.app.base.BaseService;
import cool.scx.app.bo.ParamWrapper;
import cool.scx.app.exception.BadRequestException;
import cool.scx.app.exception.CustomHttpRequestException;
import cool.scx.app.exception.HttpRequestException;
import cool.scx.app.vo.Json;
import cool.scx.core.sql.WhereType;
import cool.scx.core.util.ObjectUtils;
import cool.scx.core.util.StringUtils;
import cool.scx.core.util.ansi.Ansi;
import cool.scx.ext.crud.CRUDWhereBody;
import cool.scx.ext.crud.UnknownCRUDModelException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public final class CRUDHelper {
    private static final Map<String, Class<BaseModel>> BASE_MODEL_NAME_CLASS_MAPPING = CRUDHelper.initBaseModelNameClassMapping();
    private static final Map<Class<BaseModel>, Class<BaseService<BaseModel>>> BASE_MODEL_CLASS_BASE_SERVICE_CLASS_MAPPING = CRUDHelper.initBaseModelClassBaseServiceClassMapping();
    private static final Map<Class<BaseModel>, BaseService<BaseModel>> BASE_MODEL_CLASS_BASE_SERVICE_CACHE = new HashMap<Class<BaseModel>, BaseService<BaseModel>>();

    public static BaseService<BaseModel> getBaseService(String modelName) throws HttpRequestException {
        Class<BaseModel> baseModelClass = CRUDHelper.getBaseModelClassByName(modelName);
        try {
            BaseService baseService = BASE_MODEL_CLASS_BASE_SERVICE_CACHE.get(baseModelClass);
            if (baseService == null) {
                Class<BaseService<BaseModel>> baseServiceClass = BASE_MODEL_CLASS_BASE_SERVICE_CLASS_MAPPING.get(baseModelClass);
                baseService = baseServiceClass != null ? (BaseService)ScxAppContext.beanFactory().getBean(baseServiceClass) : new BaseService(baseModelClass);
                BASE_MODEL_CLASS_BASE_SERVICE_CACHE.put(baseModelClass, (BaseService<BaseModel>)baseService);
            }
            return baseService;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnknownCRUDModelException(modelName);
        }
    }

    public static BaseModel mapToBaseModel(Map<String, Object> entityMap, String baseModelName) throws HttpRequestException {
        Class<BaseModel> baseModelClass = CRUDHelper.getBaseModelClassByName(baseModelName);
        try {
            return (BaseModel)ObjectUtils.convertValue(entityMap, baseModelClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BadRequestException((Object)e);
        }
    }

    public static Class<BaseModel> getBaseModelClassByName(String baseModelName) throws UnknownCRUDModelException {
        if (StringUtils.isBlank((String)baseModelName)) {
            throw new UnknownCRUDModelException(baseModelName);
        }
        Class<BaseModel> baseModelClass = BASE_MODEL_NAME_CLASS_MAPPING.get(baseModelName.toLowerCase());
        if (baseModelClass == null) {
            throw new UnknownCRUDModelException(baseModelName);
        }
        return baseModelClass;
    }

    public static ParamWrapper getParamWrapper(Class<? extends BaseModel> modelClass, Integer limit, Integer page, String orderByColumn, String sortType, List<CRUDWhereBody> whereBodyList) throws CustomHttpRequestException {
        ParamWrapper paramWrapper = new ParamWrapper();
        if (limit != null && limit >= 0) {
            if (page != null && page >= 0) {
                paramWrapper.SET_PAGINATION(page, limit);
            } else {
                paramWrapper.SET_PAGINATION(limit);
            }
        }
        if (orderByColumn != null && sortType != null) {
            paramWrapper.ADD_ORDER_BY(orderByColumn, sortType);
        }
        if (whereBodyList != null) {
            for (CRUDWhereBody crudWhereBody : whereBodyList) {
                if (crudWhereBody.fieldName == null || crudWhereBody.whereType == null) continue;
                CRUDHelper.checkFieldName(modelClass, crudWhereBody.fieldName);
                WhereType whereType = CRUDHelper.checkWhereType(crudWhereBody.fieldName, crudWhereBody.whereType);
                CRUDHelper.checkWhereBodyParametersSize(crudWhereBody.fieldName, whereType, crudWhereBody.value1, crudWhereBody.value2);
                if (whereType.paramSize() == 0) {
                    paramWrapper.where().ADD(crudWhereBody.fieldName, whereType);
                    continue;
                }
                if (whereType.paramSize() == 1) {
                    paramWrapper.where().ADD(crudWhereBody.fieldName, whereType, crudWhereBody.value1);
                    continue;
                }
                if (whereType.paramSize() != 2) continue;
                paramWrapper.where().ADD(crudWhereBody.fieldName, whereType, crudWhereBody.value1, crudWhereBody.value2);
            }
        }
        return paramWrapper;
    }

    public static void checkFieldName(Class<?> modelClass, String fieldName) throws CustomHttpRequestException {
        try {
            Field field = modelClass.getField(fieldName);
            if (field.isAnnotationPresent(NoColumn.class)) {
                throw new CustomHttpRequestException(ctx -> Json.fail((String)"unknown-field-name").put("field-name", (Object)fieldName).handle(ctx));
            }
        }
        catch (Exception e) {
            throw new CustomHttpRequestException(ctx -> Json.fail((String)"unknown-field-name").put("field-name", (Object)fieldName).handle(ctx));
        }
    }

    public static WhereType checkWhereType(String fieldName, String strWhereType) throws CustomHttpRequestException {
        try {
            return WhereType.valueOf((String)strWhereType.toUpperCase());
        }
        catch (Exception ignored) {
            throw new CustomHttpRequestException(ctx -> Json.fail((String)"unknown-where-type").put("field-name", (Object)fieldName).put("where-type", (Object)strWhereType).handle(ctx));
        }
    }

    public static void checkWhereBodyParametersSize(String fieldName, WhereType whereType, Object value1, Object value2) throws CustomHttpRequestException {
        AtomicInteger paramSize = new AtomicInteger();
        if (value1 != null) {
            paramSize.set(paramSize.get() + 1);
        }
        if (value2 != null) {
            paramSize.set(paramSize.get() + 1);
        }
        if (whereType.paramSize() != paramSize.get()) {
            throw new CustomHttpRequestException(ctx -> Json.fail((String)"where-body-parameters-size-error").put("field-name", (Object)fieldName).put("where-type", (Object)whereType).put("need-parameters-size", (Object)whereType.paramSize()).put("got-parameters-size", (Object)paramSize.get()).handle(ctx));
        }
    }

    private static Map<String, Class<BaseModel>> initBaseModelNameClassMapping() {
        HashMap<String, Class<BaseModel>> tempMap = new HashMap<String, Class<BaseModel>>();
        for (ScxAppModuleInfo allModule : ScxAppContext.scxAppModuleInfos()) {
            for (Class c : allModule.scxModelClassList()) {
                String className = c.getSimpleName().toLowerCase();
                Class<BaseModel> aClass = tempMap.get(className);
                tempMap.put(className, c);
                if (aClass == null) continue;
                Ansi.out().brightRed((Object)"\u68c0\u6d4b\u5230\u91cd\u590d\u540d\u79f0\u7684 BaseModel ").brightYellow((Object)("[" + aClass.getName() + "] ")).blue((Object)("[" + c.getName() + "]")).brightRed((Object)" \u53ef\u80fd\u4f1a\u5bfc\u81f4\u6839\u636e\u540d\u79f0\u8c03\u7528\u65f6\u610f\u4e49\u4e0d\u660e\u786e !!! \u5efa\u8bae\u4fee\u6539 !!!").println();
            }
        }
        return tempMap;
    }

    private static Map<Class<BaseModel>, Class<BaseService<BaseModel>>> initBaseModelClassBaseServiceClassMapping() {
        ArrayListMultimap classClassHashSetValuedHashMap = ArrayListMultimap.create();
        Collection<Class<BaseModel>> baseModelClassList = BASE_MODEL_NAME_CLASS_MAPPING.values();
        for (ScxAppModuleInfo allModule : ScxAppContext.scxAppModuleInfos()) {
            for (Class c : allModule.scxServiceClassList()) {
                Type[] typeArguments = ((ParameterizedType)c.getGenericSuperclass()).getActualTypeArguments();
                Class baseModelClass = (Class)typeArguments[0];
                if (!baseModelClassList.contains(baseModelClass)) continue;
                classClassHashSetValuedHashMap.put((Object)baseModelClass, (Object)c);
            }
        }
        HashMap<Class<BaseModel>, Class<BaseService<BaseModel>>> tempMap = new HashMap<Class<BaseModel>, Class<BaseService<BaseModel>>>();
        for (Class key : classClassHashSetValuedHashMap.keySet()) {
            List classes = classClassHashSetValuedHashMap.get((Object)key);
            Class lastThisBaseModelClassBaseServiceClass = (Class)classes.get(classes.size() - 1);
            if (classes.size() > 1) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < classes.size() - 1; ++i) {
                    String name = ((Class)classes.get(i)).getName();
                    if (i == classes.size() - 2) {
                        sb.append("[").append(name).append("] ");
                        continue;
                    }
                    sb.append("[").append(name).append("],");
                }
                Ansi.out().brightRed((Object)("\u68c0\u6d4b\u5230\u9488\u5bf9 " + key.getName() + " \u7684\u591a\u4e2a BaseService \u5b9e\u73b0 , \u5df2\u91c7\u7528\u6700\u540e\u4e00\u4e2a [" + lastThisBaseModelClassBaseServiceClass.getName() + "] ,")).brightYellow((Object)(" \u5176\u4f59\u7684 BaseService \u5b9e\u73b0 " + sb)).println();
            }
            tempMap.put(key, lastThisBaseModelClassBaseServiceClass);
        }
        return tempMap;
    }
}

