package cool.scx.ext.crud;

import cool.scx.app.ScxAppModule;
import cool.scx.core.util.ansi.Ansi;

/**
 * 提供一些简单的增删改查功能
 *
 * @author scx567888
 * @version 1.3.0
 */
public class CRUDModule implements ScxAppModule {

    /**
     * 默认实现类
     */
    private Class<? extends CRUDHandler> crudHandlerClass = CRUDHandlerImpl.class;

    /**
     * <p>Constructor for CmsModule.</p>
     */
    public CRUDModule() {

    }

    /**
     * @param c c
     */
    public CRUDModule(Class<? extends CRUDHandler> c) {
        crudHandlerClass = c;
    }

    @Override
    public void start() {
        Ansi.out().brightBlue("CRUDHandler 实现类  -->  " + this.crudHandlerClass.getName()).println();
    }

    /**
     * 获取 crudHandler
     *
     * @return c
     */
    public Class<? extends CRUDHandler> crudHandlerClass() {
        return crudHandlerClass;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String name() {
        return "SCX_EXT-" + ScxAppModule.super.name();
    }

}