/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.cms.web_site;

import cool.scx.app.ScxAppContext;
import cool.scx.app.annotation.FromPath;
import cool.scx.app.annotation.ScxMapping;
import cool.scx.app.enumeration.HttpMethod;
import cool.scx.app.exception.NotFoundException;
import cool.scx.app.vo.Html;
import cool.scx.ext.cms.CMSModule;
import cool.scx.ext.cms.channel.Channel;
import cool.scx.ext.cms.channel.ChannelService;
import cool.scx.ext.cms.cms_config.CMSConfig;
import cool.scx.ext.cms.cms_config.CMSConfigService;
import cool.scx.ext.cms.content.Content;
import cool.scx.ext.cms.content.ContentService;
import cool.scx.ext.cms.web_site.WebSiteHandler;
import java.io.IOException;

@ScxMapping(value="/")
public class WebSiteController {
    private final ContentService contentService;
    private final ChannelService channelService;
    private final CMSConfigService cmsConfigService;
    private final WebSiteHandler webSiteHandler;

    public WebSiteController(ContentService contentService, ChannelService channelService, CMSConfigService cmsConfigService) {
        this.contentService = contentService;
        this.channelService = channelService;
        this.cmsConfigService = cmsConfigService;
        this.webSiteHandler = (WebSiteHandler)ScxAppContext.beanFactory().getBean(((CMSModule)ScxAppContext.findScxAppModuleInfo(CMSModule.class).scxAppModuleExample()).getWebSiteHandlerClass());
    }

    @ScxMapping(value="/", method={HttpMethod.GET})
    public Html index() throws Exception {
        Html html;
        CMSConfig cmsConfig = this.cmsConfigService.getCMSConfig();
        String indexTemplatePath = cmsConfig.defaultIndexTemplate;
        try {
            html = Html.ofTemplate((String)indexTemplatePath);
        }
        catch (IOException e) {
            throw new NotFoundException();
        }
        this.webSiteHandler.indexHandler(html);
        return html;
    }

    @ScxMapping(value="/:channelPath", method={HttpMethod.GET})
    public Html channel(@FromPath String channelPath) throws Exception {
        Html html;
        Channel channelByPath = this.channelService.getChannelByPath(channelPath);
        if (channelByPath == null) {
            throw new NotFoundException();
        }
        CMSConfig cmsConfig = this.cmsConfigService.getCMSConfig();
        String defaultChannelTemplate = cmsConfig.defaultChannelTemplate;
        if (channelByPath.channelTemplate != null) {
            defaultChannelTemplate = channelByPath.channelTemplate;
        }
        try {
            html = Html.ofTemplate((String)defaultChannelTemplate);
        }
        catch (IOException e) {
            throw new NotFoundException();
        }
        this.webSiteHandler.channelHandler(html, channelPath);
        html.add("channel", (Object)channelByPath);
        return html;
    }

    @ScxMapping(value="/:channelPath/:contentID", method={HttpMethod.GET})
    public Html content(@FromPath String channelPath, @FromPath Long contentID) throws Exception {
        Html html;
        Channel channelByPath = this.channelService.getChannelByPath(channelPath);
        if (channelByPath == null) {
            throw new NotFoundException();
        }
        Content content = (Content)this.contentService.get(contentID);
        if (content == null || !content.channelID.equals(channelByPath.id)) {
            throw new NotFoundException();
        }
        CMSConfig cmsConfig = this.cmsConfigService.getCMSConfig();
        String defaultContentTemplate = cmsConfig.defaultContentTemplate;
        if (content.contentTemplate != null) {
            defaultContentTemplate = content.contentTemplate;
        }
        try {
            html = Html.ofTemplate((String)defaultContentTemplate);
        }
        catch (IOException e) {
            throw new NotFoundException();
        }
        this.webSiteHandler.contentHandler(html, channelPath, contentID);
        html.add("channel", (Object)channelByPath);
        html.add("content", (Object)content);
        return html;
    }
}

