/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization;

import cool.scx.app.annotation.ScxService;
import cool.scx.app.base.BaseService;
import cool.scx.app.bo.Query;
import cool.scx.ext.organization.DeptService;
import cool.scx.ext.organization.RoleService;
import cool.scx.ext.organization.User;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@ScxService
public class UserService
extends BaseService<User> {
    private final DeptService deptService;
    private final RoleService roleService;

    public UserService(DeptService deptService, RoleService roleService) {
        this.deptService = deptService;
        this.roleService = roleService;
    }

    public User getByUsername(String uniqueID) throws SQLException {
        return (User)this.get(new Query().equal("username", (Object)uniqueID));
    }

    public List<User> listWithRoleAndDept(Query query) throws SQLException {
        List userList = super.list(query);
        List userIDs = userList.stream().map(user -> user.id).collect(Collectors.toList());
        CompletableFuture<List> userDeptListFuture = CompletableFuture.supplyAsync(() -> this.deptService.getUserDeptByUserIDs(userIDs));
        CompletableFuture<List> userRoleListFuture = CompletableFuture.supplyAsync(() -> this.roleService.getUserRoleByUserIDs(userIDs));
        try {
            List userDeptList = userDeptListFuture.get();
            List userRoleList = userRoleListFuture.get();
            return userList.stream().peek(item -> {
                item.deptIDs = userDeptList.stream().filter(userDept -> userDept.userID.equals(item.id)).map(deptItem -> deptItem.deptID).collect(Collectors.toList());
                item.roleIDs = userRoleList.stream().filter(userRole -> userRole.userID.equals(item.id)).map(deptItem -> deptItem.roleID).collect(Collectors.toList());
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

