/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization;

import cool.scx.annotation.ScxService;
import cool.scx.base.BaseService;
import cool.scx.bo.Query;
import cool.scx.ext.organization.Dept;
import cool.scx.ext.organization.User;
import cool.scx.ext.organization.UserDept;
import cool.scx.ext.organization.UserDeptService;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@ScxService
public class DeptService
extends BaseService<Dept> {
    private final UserDeptService userDeptService;

    public DeptService(UserDeptService userDeptService) {
        this.userDeptService = userDeptService;
    }

    public List<Dept> getDeptListByUser(User user) {
        try {
            List<Long> deptIDs = this.userDeptService.list(new Query().equal("userID", (Object)user.id)).stream().map(userRole -> userRole.deptID).toList();
            if (deptIDs.size() > 0) {
                return this.list(new Query().in("id", deptIDs));
            }
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
        }
        return new ArrayList<Dept>();
    }

    public void saveDeptListWithUserID(Long userID, List<Long> deptIDs) throws SQLException {
        if (deptIDs != null) {
            List idArr = deptIDs.stream().filter(Objects::nonNull).map(id -> {
                UserDept userDept = new UserDept();
                userDept.userID = userID;
                userDept.deptID = id;
                return userDept;
            }).collect(Collectors.toList());
            this.userDeptService.save(idArr);
        }
    }

    public void deleteByUserID(Long id) throws SQLException {
        this.userDeptService.delete(new Query().equal("userID", (Object)id));
    }

    public List<UserDept> findDeptByUserID(Long userID) throws SQLException {
        if (userID != null) {
            return this.userDeptService.list(new Query().equal("userID", (Object)userID));
        }
        return new ArrayList<UserDept>();
    }

    public List<UserDept> getUserDeptByUserIDs(List<Long> userIDs) {
        try {
            return this.userDeptService.list(new Query().in("userID", userIDs));
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
            return new ArrayList<UserDept>();
        }
    }
}

