/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization;

import cool.scx.annotation.ScxService;
import cool.scx.base.BaseService;
import cool.scx.bo.Query;
import cool.scx.ext.organization.Role;
import cool.scx.ext.organization.User;
import cool.scx.ext.organization.UserRole;
import cool.scx.ext.organization.UserRoleService;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@ScxService
public class RoleService
extends BaseService<Role> {
    private final UserRoleService userRoleService;

    public RoleService(UserRoleService userRoleService) {
        this.userRoleService = userRoleService;
    }

    public List<Role> getRoleListByUser(User user) {
        try {
            List<Long> roleIDs = this.userRoleService.list(new Query().equal("userID", (Object)user.id)).stream().map(userRole -> userRole.roleID).toList();
            if (roleIDs.size() > 0) {
                return this.list(new Query().in("id", roleIDs));
            }
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
        }
        return new ArrayList<Role>();
    }

    public List<UserRole> getUserRoleByUserIDs(List<Long> userIDs) {
        try {
            return this.userRoleService.list(new Query().in("userID", userIDs));
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
            return new ArrayList<UserRole>();
        }
    }

    public void saveRoleListWithUserID(Long userID, List<Long> roleIDs) throws SQLException {
        if (roleIDs != null) {
            List idArr = roleIDs.stream().filter(Objects::nonNull).map(id -> {
                UserRole userRole = new UserRole();
                userRole.userID = userID;
                userRole.roleID = id;
                return userRole;
            }).collect(Collectors.toList());
            this.userRoleService.save(idArr);
        }
    }

    public void deleteByUserID(Long id) throws SQLException {
        this.userRoleService.delete(new Query().equal("userID", (Object)id));
    }
}

