/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization.auth;

import cool.scx.ScxContext;
import cool.scx.ext.organization.DeptService;
import cool.scx.ext.organization.RoleService;
import cool.scx.ext.organization.User;
import cool.scx.ext.organization.UserService;
import cool.scx.ext.organization.auth.OrganizationAuthDeviceType;
import cool.scx.ext.organization.auth.OrganizationAuthInterceptor;
import cool.scx.mvc.interceptor.ScxMappingInterceptor;
import cool.scx.mvc.interceptor.ScxMappingInterceptorConfiguration;
import cool.scx.util.RandomUtils;
import cool.scx.util.ansi.Ansi;
import cool.scx.web.handler.ScxCookieHandlerConfiguration;
import cool.scx.web.handler.ScxCorsHandlerConfiguration;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.impl.CookieImpl;
import io.vertx.ext.web.RoutingContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class OrganizationAuth {
    private static final String SCX_AUTH_TOKEN_KEY = "S-Token";
    private static final String SCX_AUTH_DEVICE_KEY = "S-Device";
    private static final List<LoginItem> LOGIN_ITEMS = new ArrayList<LoginItem>();
    private static final String SCX_ORGANIZATION_SESSION_PATH = "AppRoot:scx-organization-session.bin";
    private static UserService userService;
    private static RoleService roleService;
    private static DeptService deptService;

    static void initAuth() {
        ScxMappingInterceptorConfiguration.setScxMappingInterceptor((ScxMappingInterceptor)new OrganizationAuthInterceptor());
        ScxCorsHandlerConfiguration.allowedHeaders(OrganizationAuth.authHeaders());
        ScxCookieHandlerConfiguration.setScxCookieHandler(ctx -> {
            if (ctx.request().getCookie(SCX_AUTH_TOKEN_KEY) == null) {
                CookieImpl cookie = new CookieImpl(SCX_AUTH_TOKEN_KEY, RandomUtils.getUUID());
                cookie.setMaxAge(604800L);
                ctx.request().response().addCookie((Cookie)cookie);
            }
            ctx.next();
        });
        userService = (UserService)((Object)ScxContext.beanFactory().getBean(UserService.class));
        roleService = (RoleService)((Object)ScxContext.beanFactory().getBean(RoleService.class));
        deptService = (DeptService)((Object)ScxContext.beanFactory().getBean(DeptService.class));
    }

    public static User getLoginUser() {
        return OrganizationAuth.getLoginUser(ScxContext.routingContext());
    }

    public static Boolean isAdmin() {
        User user = OrganizationAuth.getLoginUser();
        if (user != null) {
            return user.isAdmin;
        }
        return null;
    }

    public static Set<String> getPerms() {
        return OrganizationAuth.getPerms(OrganizationAuth.getLoginUser());
    }

    static void readSessionFromFile() {
        File sessionCache = ScxContext.getFileByAppRoot((String)SCX_ORGANIZATION_SESSION_PATH);
        try (FileInputStream f = new FileInputStream(sessionCache);
             ObjectInputStream o = new ObjectInputStream(f);){
            LoginItem[] loginItems = (LoginItem[])o.readObject();
            Collections.addAll(LOGIN_ITEMS, loginItems);
            Ansi.out().brightGreen((Object)("\u6210\u529f\u4ece " + sessionCache.getPath() + " \u4e2d\u6062\u590d " + loginItems.length + " \u6761\u6570\u636e!!!")).println();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void writeSessionToFile() {
        File sessionCache = ScxContext.getFileByAppRoot((String)SCX_ORGANIZATION_SESSION_PATH);
        try (FileOutputStream f = new FileOutputStream(sessionCache);
             ObjectOutputStream o = new ObjectOutputStream(f);){
            o.writeObject(LOGIN_ITEMS.toArray(new LoginItem[0]));
            Ansi.out().red((Object)("\u4fdd\u5b58 Session \u5230 " + sessionCache.getPath() + " \u4e2d!!!")).println();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static User getLoginUser(RoutingContext ctx) {
        return OrganizationAuth.getLoginUserByToken(OrganizationAuth.getToken(ctx));
    }

    static void addLoginItem(String token, User authUser, OrganizationAuthDeviceType loginDevice) {
        LoginItem sessionItem = LOGIN_ITEMS.stream().filter(u -> authUser.id.equals(u.user.id) && loginDevice == u.loginDevice).findAny().orElse(null);
        if (sessionItem == null) {
            LOGIN_ITEMS.add(new LoginItem(token, authUser, loginDevice));
        } else {
            sessionItem.token = token;
        }
    }

    public static User getLoginUserByToken(String token) {
        LoginItem sessionItem = LOGIN_ITEMS.stream().filter(u -> u.token.equals(token)).findAny().orElse(null);
        if (sessionItem == null) {
            return null;
        }
        try {
            return (User)userService.get(sessionItem.user.id);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    static String getTokenByCookie(RoutingContext routingContext) {
        return routingContext.request().getCookie(SCX_AUTH_TOKEN_KEY).getValue();
    }

    static String getTokenByHeader(RoutingContext routingContext) {
        return routingContext.request().getHeader(SCX_AUTH_TOKEN_KEY);
    }

    static OrganizationAuthDeviceType getDeviceTypeByHeader(RoutingContext routingContext) {
        String device = routingContext.request().getHeader(SCX_AUTH_DEVICE_KEY);
        if (device == null) {
            return OrganizationAuthDeviceType.WEBSITE;
        }
        return OrganizationAuthDeviceType.of(device);
    }

    private static Set<String> authHeaders() {
        HashSet<String> set = new HashSet<String>();
        set.add(SCX_AUTH_TOKEN_KEY);
        set.add(SCX_AUTH_DEVICE_KEY);
        return set;
    }

    private static String getToken(RoutingContext ctx) {
        OrganizationAuthDeviceType device = OrganizationAuth.getDeviceTypeByHeader(ctx);
        return switch (device) {
            case OrganizationAuthDeviceType.WEBSITE -> OrganizationAuth.getTokenByCookie(ctx);
            case OrganizationAuthDeviceType.ADMIN, OrganizationAuthDeviceType.APPLE, OrganizationAuthDeviceType.ANDROID -> OrganizationAuth.getTokenByHeader(ctx);
            default -> null;
        };
    }

    static HashSet<String> getPerms(User user) {
        HashSet<String> permList = new HashSet<String>();
        if (user.isAdmin.booleanValue()) {
            permList.add("*");
        } else {
            roleService.getRoleListByUser(user).forEach(role -> permList.addAll(role.perms));
            deptService.getDeptListByUser(user).forEach(dept -> permList.addAll(dept.perms));
        }
        return permList;
    }

    static boolean removeAuthUser(RoutingContext ctx) {
        String token = OrganizationAuth.getToken(ctx);
        return LOGIN_ITEMS.removeIf(i -> i.token.equals(token));
    }

    static List<LoginItem> getAllLoginItem() {
        return LOGIN_ITEMS;
    }

    private static final class LoginItem
    implements Serializable {
        public final User user;
        public final OrganizationAuthDeviceType loginDevice;
        public String token;

        public LoginItem(String token, User user, OrganizationAuthDeviceType loginDevice) {
            this.token = token;
            this.user = user;
            this.loginDevice = loginDevice;
        }
    }
}

