/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.core;

import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.util.JacksonHelper;
import cool.scx.vo.VoHelper;
import io.vertx.core.http.ServerWebSocket;

public class WSBody {
    private final Body body;
    private final ServerWebSocket webSocket;

    public WSBody(String eventName, JsonNode data, ServerWebSocket webSocket) {
        this.body = new Body(eventName, data);
        this.webSocket = webSocket;
    }

    public WSBody(String eventName, Object data, ServerWebSocket webSocket) {
        this.body = new Body(eventName, JacksonHelper.getObjectMapper().valueToTree(data));
        this.webSocket = webSocket;
    }

    public JsonNode data() {
        return this.body.data;
    }

    public String eventName() {
        return this.body.eventName;
    }

    public String toJson() {
        return VoHelper.toJson((Object)this.body, (String)"");
    }

    public ServerWebSocket webSocket() {
        return this.webSocket;
    }

    private record Body(String eventName, JsonNode data) {
    }
}

