/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.base.BaseModel;
import cool.scx.base.BaseService;
import cool.scx.bo.Query;
import cool.scx.ext.crud.CRUDHelper;
import cool.scx.ext.crud.CRUDListResult;
import cool.scx.ext.crud.CRUDOrderByBody;
import cool.scx.ext.crud.CRUDWhereBody;
import cool.scx.sql.where.WhereOption;
import java.util.List;
import java.util.Map;

public interface CRUDHandler {
    default public boolean checkUnique(String modelName, String fieldName, Object value, Long id) {
        BaseService<BaseModel> baseService = CRUDHelper.getBaseService(modelName);
        Query query = new Query().equal(fieldName, value, new WhereOption[0]);
        if (id != null) {
            query.notEqual("id", (Object)id, new WhereOption[0]);
        }
        return baseService.count(query) == 0L;
    }

    default public List<Map<String, Object>> getAutoComplete(String modelName, String fieldName) {
        BaseService<BaseModel> baseService = CRUDHelper.getBaseService(modelName);
        return baseService.getFieldList(fieldName);
    }

    default public boolean revokeDelete(String modelName, Long id) {
        BaseService<BaseModel> baseService = CRUDHelper.getBaseService(modelName);
        long revokeDeleteCount = baseService.revokeDelete(new long[]{id});
        return revokeDeleteCount == 1L;
    }

    default public long batchDelete(String modelName, long[] deleteIDs) {
        BaseService<BaseModel> baseService = CRUDHelper.getBaseService(modelName);
        return baseService.delete(deleteIDs);
    }

    default public boolean delete(String modelName, Long id) {
        BaseService<BaseModel> baseService = CRUDHelper.getBaseService(modelName);
        long deletedCount = baseService.delete(new long[]{id});
        return deletedCount == 1L;
    }

    default public BaseModel update(String modelName, Map<String, Object> entityMap) {
        BaseService<BaseModel> baseService = CRUDHelper.getBaseService(modelName);
        BaseModel realObject = CRUDHelper.mapToBaseModel(entityMap, modelName);
        return baseService.update(realObject);
    }

    default public BaseModel save(String modelName, Map<String, Object> entityMap) {
        BaseService<BaseModel> baseService = CRUDHelper.getBaseService(modelName);
        BaseModel realObject = CRUDHelper.mapToBaseModel(entityMap, modelName);
        return baseService.save(realObject);
    }

    default public BaseModel info(String modelName, Long id) {
        BaseService<BaseModel> baseService = CRUDHelper.getBaseService(modelName);
        return baseService.get(id.longValue());
    }

    default public CRUDListResult list(String modelName, Integer limit, Integer page, List<CRUDOrderByBody> orderByBodyList, List<CRUDWhereBody> whereBodyList) {
        BaseService<BaseModel> baseService = CRUDHelper.getBaseService(modelName);
        Query query = CRUDHelper.getQuery(CRUDHelper.getBaseModelClassByName(modelName), limit, page, orderByBodyList, whereBodyList);
        List list = baseService.list(query);
        long total = baseService.count(query);
        return new CRUDListResult(list, total);
    }
}

