/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.cms.directive;

import cool.scx.annotation.ScxService;
import cool.scx.base.BaseTemplateDirective;
import cool.scx.bo.Query;
import cool.scx.ext.cms.channel.ChannelService;
import cool.scx.sql.order_by.OrderByOption;
import cool.scx.sql.order_by.OrderByType;
import cool.scx.sql.where.WhereOption;
import java.util.Map;

@ScxService
public class ChannelListDirective
implements BaseTemplateDirective {
    private final ChannelService channelService;

    public ChannelListDirective(ChannelService channelService) {
        this.channelService = channelService;
    }

    public Object handle(Map<String, Object> params) {
        Integer page;
        Query query = new Query();
        Object id = params.get("id");
        Object parentID = params.get("parentID");
        Object hasChannelTitleImage = params.get("hasChannelTitleImage");
        Object orderByColumn = params.get("orderByColumn");
        Object sortType = params.get("sortType");
        Integer limit = params.get("limit") != null ? Integer.valueOf(params.get("limit").toString()) : null;
        Integer n = page = params.get("page") != null ? Integer.valueOf(params.get("page").toString()) : null;
        if (id != null) {
            query.equal("id", (Object)Long.valueOf(id.toString()), new WhereOption[0]);
        }
        if (parentID != null) {
            query.equal("parentID", (Object)Long.valueOf(parentID.toString()), new WhereOption[0]);
        }
        if (hasChannelTitleImage != null) {
            if (Boolean.parseBoolean(hasChannelTitleImage.toString())) {
                query.isNotNull("channelTitleImage", new WhereOption[0]);
            } else {
                query.isNull("channelTitleImage", new WhereOption[0]);
            }
        }
        if (limit != null && limit >= 0) {
            if (page != null && page >= 0) {
                query.setPagination(page, limit);
            } else {
                query.setPagination(limit);
            }
        }
        if (orderByColumn != null && sortType != null) {
            query.orderBy().add(orderByColumn.toString(), OrderByType.of((String)sortType.toString()), new OrderByOption[0]);
        }
        return this.channelService.list(query);
    }

    public String directiveName() {
        return "channel_list_tag";
    }

    public String variableName() {
        return "channel_list";
    }
}

