/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization.auth;

import cool.scx.exception.impl.NoPermException;
import cool.scx.exception.impl.UnauthorizedException;
import cool.scx.ext.organization.User;
import cool.scx.ext.organization.auth.OrganizationAuth;
import cool.scx.ext.organization.auth.OrganizationAuthPerms;
import cool.scx.mvc.ScxMappingHandler;
import cool.scx.mvc.interceptor.ScxMappingInterceptor;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.Map;

public final class OrganizationAuthInterceptor
implements ScxMappingInterceptor {
    private final Map<ScxMappingHandler, OrganizationAuthPerms> SCX_AUTH_PERMS_CACHE = new HashMap<ScxMappingHandler, OrganizationAuthPerms>();

    public void preHandle(RoutingContext context, ScxMappingHandler scxMappingHandler) {
        OrganizationAuthPerms p = this.getScxAuthPerms(scxMappingHandler);
        if (p.checkedLogin) {
            User currentUser = OrganizationAuth.getLoginUser(context);
            if (currentUser == null) {
                throw new UnauthorizedException();
            }
            if (p.checkedPerms && !currentUser.isAdmin.booleanValue() && !OrganizationAuth.getPerms(currentUser).contains(p.permStr)) {
                throw new NoPermException();
            }
        }
    }

    private OrganizationAuthPerms getScxAuthPerms(ScxMappingHandler s) {
        OrganizationAuthPerms p = this.SCX_AUTH_PERMS_CACHE.get(s);
        if (p == null) {
            OrganizationAuthPerms scxMappingHandlerPerms = new OrganizationAuthPerms(s.clazz, s.method);
            this.SCX_AUTH_PERMS_CACHE.put(s, scxMappingHandlerPerms);
            return scxMappingHandlerPerms;
        }
        return p;
    }
}

