/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.cms.directive;

import cool.scx.annotation.ScxService;
import cool.scx.base.BaseTemplateDirective;
import cool.scx.bo.Query;
import cool.scx.ext.cms.content.ContentService;
import cool.scx.sql.order_by.OrderByOption;
import cool.scx.sql.order_by.OrderByType;
import cool.scx.sql.where.WhereOption;
import java.util.Map;

@ScxService
public class ContentListDirective
implements BaseTemplateDirective {
    private final ContentService contentService;

    public ContentListDirective(ContentService contentService) {
        this.contentService = contentService;
    }

    public Object handle(Map<String, Object> params) {
        Integer page;
        Query query = new Query();
        Object id = params.get("id");
        Object channelID = params.get("channelID");
        Object hasContentTitleImage = params.get("hasContentTitleImage");
        Object orderByColumn = params.get("orderByColumn");
        Object sortType = params.get("sortType");
        Integer limit = params.get("limit") != null ? Integer.valueOf(params.get("limit").toString()) : null;
        Integer n = page = params.get("page") != null ? Integer.valueOf(params.get("page").toString()) : null;
        if (id != null) {
            query.equal("id", (Object)Long.valueOf(id.toString()), new WhereOption[0]);
        }
        if (channelID != null) {
            query.equal("channelID", (Object)Long.valueOf(channelID.toString()), new WhereOption[0]);
        }
        if (hasContentTitleImage != null) {
            if (Boolean.parseBoolean(hasContentTitleImage.toString())) {
                query.isNotNull("contentTitleImage", new WhereOption[0]);
            } else {
                query.isNull("contentTitleImage", new WhereOption[0]);
            }
        }
        if (limit != null && limit >= 0) {
            if (page != null && page >= 0) {
                query.setPagination(page, limit);
            } else {
                query.setPagination(limit);
            }
        }
        if (orderByColumn != null && sortType != null) {
            query.orderBy().add(orderByColumn.toString(), OrderByType.of((String)sortType.toString()), new OrderByOption[0]);
        }
        return this.contentService.list();
    }

    public String directiveName() {
        return "content_list_tag";
    }

    public String variableName() {
        return "content_list";
    }
}

