/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.core;

import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.ScxContext;
import cool.scx.annotation.ScxWebSocketMapping;
import cool.scx.base.BaseWebSocketHandler;
import cool.scx.ext.core.CoreOnlineItemHandler;
import cool.scx.ext.core.WSBody;
import cool.scx.util.ObjectUtils;
import cool.scx.util.ansi.Ansi;
import cool.scx.util.ansi.AnsiElement;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScxWebSocketMapping(value="/scx")
public class CoreWebSocketHandler
implements BaseWebSocketHandler {
    private static final Logger logger = LoggerFactory.getLogger(CoreWebSocketHandler.class);
    private static final String LOVE = "\u2764";

    private static WSBody createScxWebSocketEvent(String text, ServerWebSocket webSocket) {
        try {
            JsonNode jsonNode = ObjectUtils.mapper().readTree(text);
            String eventName = jsonNode.get("eventName").asText();
            return new WSBody(eventName, jsonNode.get("data"), webSocket);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void onOpen(ServerWebSocket webSocket) {
        CoreOnlineItemHandler.addOnlineItem(webSocket, null);
        logger.debug("{} \u8fde\u63a5\u4e86!!! \u5f53\u524d\u603b\u8fde\u63a5\u6570 : {}", (Object)webSocket.binaryHandlerID(), (Object)CoreOnlineItemHandler.getOnlineItemList().size());
    }

    public void onClose(ServerWebSocket webSocket) {
        CoreOnlineItemHandler.removeOnlineItemByWebSocket(webSocket);
        logger.debug("{} \u5173\u95ed\u4e86!!! \u5f53\u524d\u603b\u8fde\u63a5\u6570 : {}", (Object)webSocket.binaryHandlerID(), (Object)CoreOnlineItemHandler.getOnlineItemList().size());
    }

    public void onTextMessage(String textData, WebSocketFrame h, ServerWebSocket webSocket) {
        if (LOVE.equals(textData)) {
            webSocket.writeTextMessage(LOVE);
        } else {
            WSBody event = CoreWebSocketHandler.createScxWebSocketEvent(textData, webSocket);
            if (event != null) {
                ScxContext.eventBus().publish(event.eventName(), (Object)event);
            }
        }
    }

    public void onBinaryMessage(Buffer binaryData, WebSocketFrame h, ServerWebSocket webSocket) {
        Ansi.out().color((Object)"onBinaryMessage", new AnsiElement[0]).println();
    }

    public void onError(Throwable event, ServerWebSocket webSocket) {
        event.printStackTrace();
    }
}

