/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization;

import cool.scx.annotation.ScxService;
import cool.scx.base.BaseService;
import cool.scx.bo.Query;
import cool.scx.ext.organization.Dept;
import cool.scx.ext.organization.User;
import cool.scx.ext.organization.UserDept;
import cool.scx.ext.organization.UserDeptService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@ScxService
public class DeptService
extends BaseService<Dept> {
    private final UserDeptService userDeptService;

    public DeptService(UserDeptService userDeptService) {
        this.userDeptService = userDeptService;
    }

    public List<Dept> getDeptListByUser(User user) {
        List<Long> deptIDs = this.userDeptService.list(new Query().equal("userID", (Object)user.id)).stream().map(userRole -> userRole.deptID).toList();
        if (deptIDs.size() > 0) {
            return this.list(new Query().in("id", deptIDs));
        }
        return new ArrayList<Dept>();
    }

    public void saveDeptListWithUserID(Long userID, List<Long> deptIDs) {
        if (deptIDs != null) {
            List idArr = deptIDs.stream().filter(Objects::nonNull).map(id -> {
                UserDept userDept = new UserDept();
                userDept.userID = userID;
                userDept.deptID = id;
                return userDept;
            }).collect(Collectors.toList());
            this.userDeptService.save(idArr);
        }
    }

    public void deleteByUserID(Long id) {
        this.userDeptService.delete(new Query().equal("userID", (Object)id));
    }

    public List<UserDept> findDeptByUserID(Long userID) {
        if (userID != null) {
            return this.userDeptService.list(new Query().equal("userID", (Object)userID));
        }
        return new ArrayList<UserDept>();
    }

    public List<UserDept> getUserDeptByUserIDs(List<Long> userIDs) {
        if (userIDs.size() > 0) {
            return this.userDeptService.list(new Query().in("userID", userIDs));
        }
        return new ArrayList<UserDept>();
    }
}

