/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.ScxContext;
import cool.scx.annotation.FromBody;
import cool.scx.annotation.FromPath;
import cool.scx.annotation.ScxMapping;
import cool.scx.base.BaseModel;
import cool.scx.enumeration.HttpMethod;
import cool.scx.ext.crud.CRUDHandler;
import cool.scx.ext.crud.CRUDListResult;
import cool.scx.ext.crud.CRUDModule;
import cool.scx.ext.crud.CRUDOrderByBody;
import cool.scx.ext.crud.CRUDWhereBody;
import cool.scx.vo.Json;
import java.util.List;
import java.util.Map;

@ScxMapping(value="api/crud")
public class CRUDController {
    private final CRUDHandler crudHandler;

    public CRUDController() {
        Class<? extends CRUDHandler> crudHandlerClass = ((CRUDModule)ScxContext.findScxModuleInfo(CRUDModule.class).scxModuleExample()).crudHandlerClass();
        this.crudHandler = (CRUDHandler)ScxContext.beanFactory().getBean(crudHandlerClass);
    }

    @ScxMapping(value=":modelName/list", method={HttpMethod.POST})
    public Json list(@FromPath String modelName, @FromBody(value="pagination.limit", required=false) Integer limit, @FromBody(value="pagination.page", required=false) Integer page, @FromBody(value="orderByBodyList", required=false) List<CRUDOrderByBody> orderByBodyList, @FromBody(value="whereBodyList", required=false) List<CRUDWhereBody> whereBodyList) {
        CRUDListResult crudListResult = this.crudHandler.list(modelName, limit, page, orderByBodyList, whereBodyList);
        return Json.ok().put("items", crudListResult.list()).put("total", (Object)crudListResult.total());
    }

    @ScxMapping(value=":modelName/:id", method={HttpMethod.GET})
    public Json info(@FromPath String modelName, @FromPath Long id) {
        BaseModel info = this.crudHandler.info(modelName, id);
        return Json.ok().put("info", (Object)info);
    }

    @ScxMapping(value=":modelName", method={HttpMethod.POST})
    public Json save(@FromPath String modelName, @FromBody(useAllBody=true) Map<String, Object> entityMap) {
        BaseModel savedModel = this.crudHandler.save(modelName, entityMap);
        return Json.ok().put("item", (Object)savedModel);
    }

    @ScxMapping(value=":modelName", method={HttpMethod.PUT})
    public Json update(@FromPath String modelName, @FromBody(useAllBody=true) Map<String, Object> entityMap) {
        BaseModel updatedModel = this.crudHandler.update(modelName, entityMap);
        return Json.ok().put("item", (Object)updatedModel);
    }

    @ScxMapping(value=":modelName/:id", method={HttpMethod.DELETE})
    public Json delete(@FromPath String modelName, @FromPath Long id) {
        boolean b = this.crudHandler.delete(modelName, id);
        return b ? Json.ok() : Json.fail();
    }

    @ScxMapping(value=":modelName/batch-delete", method={HttpMethod.DELETE})
    public Json batchDelete(@FromPath String modelName, @FromBody long[] deleteIDs) {
        long deletedCount = this.crudHandler.batchDelete(modelName, deleteIDs);
        return Json.ok().put("deletedCount", (Object)deletedCount);
    }

    @ScxMapping(value=":modelName/revoke-delete/:id", method={HttpMethod.GET})
    public Json revokeDelete(@FromPath String modelName, @FromPath Long id) {
        if (!ScxContext.easyConfig().tombstone()) {
            return Json.fail((String)"not-used-tombstone");
        }
        boolean b = this.crudHandler.revokeDelete(modelName, id);
        return b ? Json.ok() : Json.fail();
    }

    @ScxMapping(value=":modelName/check-unique/:fieldName", method={HttpMethod.POST})
    public Json checkUnique(@FromPath String modelName, @FromPath String fieldName, @FromBody Object value, @FromBody(required=false) Long id) {
        boolean b = this.crudHandler.checkUnique(modelName, fieldName, value, id);
        return Json.ok().put("isUnique", (Object)b);
    }
}

