/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.core;

import com.google.common.collect.ArrayListMultimap;
import cool.scx.ScxContext;
import cool.scx.ScxHandler;
import cool.scx.ext.core.WSBody;
import cool.scx.ext.core.WSParam;
import cool.scx.util.ObjectUtils;
import cool.scx.util.StringUtils;
import io.vertx.core.http.ServerWebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WSParamHandlerRegister {
    private static final Logger logger = LoggerFactory.getLogger(WSParamHandlerRegister.class);
    private static final ArrayListMultimap<String, ScxHandler<WSParam>> NAME_SCX_HANDLER_MAPPING = ArrayListMultimap.create();

    static void findAndHandle(String textData, ServerWebSocket webSocket) {
        try {
            WSBody wsBody = (WSBody)ObjectUtils.jsonMapper().readValue(textData, WSBody.class);
            if (StringUtils.isNotBlank((String)wsBody.name())) {
                WSParam wsParam = new WSParam(wsBody.data(), webSocket);
                NAME_SCX_HANDLER_MAPPING.get((Object)wsBody.name()).forEach(scxHandler -> ScxContext.scheduler().submit(() -> scxHandler.handle((Object)wsParam)));
            }
        }
        catch (Exception e) {
            logger.debug("\u6267\u884c Handler \u51fa\u9519", (Throwable)e);
        }
    }

    public static void addHandler(String name, ScxHandler<WSParam> scxHandler) {
        NAME_SCX_HANDLER_MAPPING.put((Object)name, scxHandler);
    }

    public static void removeAllHandler(String name) {
        NAME_SCX_HANDLER_MAPPING.removeAll((Object)name);
    }

    public static void removeHandler(String name, ScxHandler<WSParam> scxHandler) {
        NAME_SCX_HANDLER_MAPPING.remove((Object)name, scxHandler);
    }
}

