/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.fss;

import cool.scx.ScxContext;
import cool.scx.annotation.FromBody;
import cool.scx.annotation.FromPath;
import cool.scx.annotation.FromQuery;
import cool.scx.annotation.FromUpload;
import cool.scx.annotation.ScxMapping;
import cool.scx.enumeration.HttpMethod;
import cool.scx.ext.fss.FSSHandler;
import cool.scx.ext.fss.FSSModule;
import cool.scx.type.UploadedEntity;
import cool.scx.vo.Download;
import cool.scx.vo.Image;
import cool.scx.vo.Json;
import cool.scx.vo.Raw;
import java.io.IOException;
import java.util.List;

@ScxMapping(value="/api/fss")
public class FSSController {
    private final FSSHandler fssHandler;

    public FSSController() {
        FSSModule fssModuleExample = (FSSModule)ScxContext.findScxModuleInfo(FSSModule.class).scxModuleExample();
        this.fssHandler = (FSSHandler)ScxContext.getBean(fssModuleExample.fssHandlerClass());
    }

    @ScxMapping(value="/download/:fssObjectID", method={HttpMethod.GET, HttpMethod.HEAD})
    public Download download(@FromPath String fssObjectID) {
        return this.fssHandler.download(fssObjectID);
    }

    @ScxMapping(value="/image/:fssObjectID", method={HttpMethod.GET, HttpMethod.HEAD})
    public Image image(@FromPath String fssObjectID, @FromQuery(value="w", required=false) Integer width, @FromQuery(value="h", required=false) Integer height, @FromQuery(value="t", required=false) String type) {
        return this.fssHandler.image(fssObjectID, width, height, type);
    }

    @ScxMapping(value="/raw/:fssObjectID", method={HttpMethod.GET, HttpMethod.HEAD})
    public Raw raw(@FromPath String fssObjectID) {
        return this.fssHandler.raw(fssObjectID);
    }

    @ScxMapping(value="/upload", method={HttpMethod.POST})
    public Json upload(@FromBody String fileName, @FromBody Long fileSize, @FromBody String fileMD5, @FromBody Integer chunkLength, @FromBody Integer nowChunkIndex, @FromUpload UploadedEntity fileData) throws Exception {
        return this.fssHandler.upload(fileName, fileSize, fileMD5, chunkLength, nowChunkIndex, fileData);
    }

    @ScxMapping(value="/delete", method={HttpMethod.DELETE})
    public Json delete(@FromBody String fssObjectID) {
        return this.fssHandler.delete(fssObjectID);
    }

    @ScxMapping(value="check-any-file-exists-by-this-md5", method={HttpMethod.POST})
    public Json checkAnyFileExistsByThisMD5(@FromBody String fileName, @FromBody Long fileSize, @FromBody String fileMD5) throws IOException {
        return this.fssHandler.checkAnyFileExistsByThisMD5(fileName, fileSize, fileMD5);
    }

    @ScxMapping(value="/list", method={HttpMethod.POST})
    public Json list(@FromBody List<String> fssObjectIDs) {
        return this.fssHandler.list(fssObjectIDs);
    }
}

