/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.base.BaseModel;
import cool.scx.base.BaseModelService;
import cool.scx.base.Query;
import cool.scx.ext.crud.CRUDHelper;
import cool.scx.ext.crud.CRUDListResult;
import cool.scx.ext.crud.CRUDOrderByBody;
import cool.scx.ext.crud.CRUDWhereBody;
import cool.scx.sql.where.WhereOption;
import java.util.List;
import java.util.Map;

public interface CRUDHandler {
    default public boolean checkUnique(String modelName, String fieldName, Object value, Long id) {
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(modelName);
        Query query = new Query().equal(fieldName, value, new WhereOption[0]);
        if (id != null) {
            query.notEqual("id", (Object)id, new WhereOption[0]);
        }
        return baseModelService.count(query) == 0L;
    }

    default public boolean revokeDelete(String modelName, Long id) {
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(modelName);
        long revokeDeleteCount = baseModelService.revokeDelete(new long[]{id});
        return revokeDeleteCount == 1L;
    }

    default public long batchDelete(String modelName, long[] deleteIDs) {
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(modelName);
        return baseModelService.delete(deleteIDs);
    }

    default public boolean delete(String modelName, Long id) {
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(modelName);
        long deletedCount = baseModelService.delete(new long[]{id});
        return deletedCount == 1L;
    }

    default public BaseModel update(String modelName, Map<String, Object> entityMap) {
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(modelName);
        BaseModel realObject = CRUDHelper.mapToBaseModel(entityMap, modelName);
        return baseModelService.update(realObject);
    }

    default public BaseModel save(String modelName, Map<String, Object> entityMap) {
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(modelName);
        BaseModel realObject = CRUDHelper.mapToBaseModel(entityMap, modelName);
        return baseModelService.save(realObject);
    }

    default public BaseModel info(String modelName, Long id) {
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(modelName);
        return baseModelService.get(id.longValue());
    }

    default public CRUDListResult list(String modelName, Integer limit, Integer page, List<CRUDOrderByBody> orderByBodyList, List<CRUDWhereBody> whereBodyList) {
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(modelName);
        Query query = CRUDHelper.getQuery(CRUDHelper.getBaseModelClassByName(modelName), limit, page, orderByBodyList, whereBodyList);
        List list = baseModelService.list(query);
        long total = baseModelService.count(query);
        return new CRUDListResult(list, total);
    }
}

