/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.base.BaseModel;
import cool.scx.base.BaseModelService;
import cool.scx.base.Query;
import cool.scx.base.SelectFilter;
import cool.scx.ext.crud.CRUDHelper;
import cool.scx.ext.crud.CRUDListResult;
import cool.scx.ext.crud.CRUDOrderByBody;
import cool.scx.ext.crud.CRUDSelectFilterBody;
import cool.scx.ext.crud.CRUDWhereBody;
import cool.scx.sql.where.WhereOption;
import java.util.List;
import java.util.Map;

public interface CRUDHandler {
    default public boolean checkUnique(String modelName, String fieldName, Object value, Long id) {
        Class<BaseModel> baseModelClass = CRUDHelper.getBaseModelClass(modelName);
        CRUDHelper.checkFieldName(baseModelClass, fieldName);
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(baseModelClass);
        Query query = new Query().equal(fieldName, value, new WhereOption[0]).notEqual("id", (Object)id, new WhereOption[]{WhereOption.SKIP_IF_NULL});
        return baseModelService.count(query) == 0L;
    }

    default public boolean revokeDelete(String modelName, Long id) {
        Class<BaseModel> baseModelClass = CRUDHelper.getBaseModelClass(modelName);
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(baseModelClass);
        return baseModelService.revokeDelete(new long[]{id}) == 1L;
    }

    default public long batchDelete(String modelName, long[] deleteIDs) {
        Class<BaseModel> baseModelClass = CRUDHelper.getBaseModelClass(modelName);
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(baseModelClass);
        return baseModelService.delete(deleteIDs);
    }

    default public boolean delete(String modelName, Long id) {
        Class<BaseModel> baseModelClass = CRUDHelper.getBaseModelClass(modelName);
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(baseModelClass);
        return baseModelService.delete(new long[]{id}) == 1L;
    }

    default public BaseModel update(String modelName, Map<String, Object> entityMap) {
        Class<BaseModel> baseModelClass = CRUDHelper.getBaseModelClass(modelName);
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(baseModelClass);
        BaseModel realObject = CRUDHelper.mapToBaseModel(entityMap, baseModelClass);
        return baseModelService.update(realObject);
    }

    default public BaseModel save(String modelName, Map<String, Object> entityMap) {
        Class<BaseModel> baseModelClass = CRUDHelper.getBaseModelClass(modelName);
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(baseModelClass);
        BaseModel realObject = CRUDHelper.mapToBaseModel(entityMap, baseModelClass);
        return baseModelService.save(realObject);
    }

    default public BaseModel info(String modelName, Long id) {
        Class<BaseModel> baseModelClass = CRUDHelper.getBaseModelClass(modelName);
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(baseModelClass);
        return baseModelService.get(id.longValue());
    }

    default public CRUDListResult list(String modelName, Integer currentPage, Integer pageSize, List<CRUDOrderByBody> orderByBodyList, List<CRUDWhereBody> whereBodyList, CRUDSelectFilterBody selectFilterBody) {
        Class<BaseModel> baseModelClass = CRUDHelper.getBaseModelClass(modelName);
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(baseModelClass);
        Query query = CRUDHelper.getQuery(baseModelClass, currentPage, pageSize, orderByBodyList, whereBodyList);
        SelectFilter selectFilter = CRUDHelper.getSelectFilter(baseModelClass, selectFilterBody, baseModelService._scxDaoTableInfo());
        List list = baseModelService.list(query, selectFilter);
        long total = baseModelService.count(query);
        return new CRUDListResult(list, total);
    }
}

