/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.static_server;

import cool.scx.ScxContext;
import cool.scx.ScxHandlerR;
import cool.scx.ScxModule;
import cool.scx.ext.static_server.ConvertStaticServerHandler;
import cool.scx.ext.static_server.StaticServer;
import io.vertx.core.Handler;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.FileSystemAccess;
import io.vertx.ext.web.handler.StaticHandler;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticServerModule
implements ScxModule {
    private static final Logger logger = LoggerFactory.getLogger(StaticServerModule.class);

    private static List<StaticServer> getStaticServersByConfig() {
        return (List)ScxContext.config().get("static-servers", (ScxHandlerR)new ConvertStaticServerHandler(ScxContext.environment()));
    }

    private static void registerStaticServerHandler(Router vertxRouter, List<StaticServer> staticServers) {
        for (StaticServer staticServer : staticServers) {
            vertxRouter.route(staticServer.location()).handler((Handler)StaticHandler.create((FileSystemAccess)FileSystemAccess.ROOT, (String)staticServer.root().getPath()).setFilesReadOnly(false));
        }
    }

    public void start() {
        List<StaticServer> staticServers = StaticServerModule.getStaticServersByConfig();
        logger.info("\u9759\u6001\u8d44\u6e90\u670d\u52a1\u5668 -->  {}", (Object)staticServers.stream().map(StaticServer::location).collect(Collectors.joining(", ", "[", "]")));
        StaticServerModule.registerStaticServerHandler(ScxContext.router().vertxRouter(), staticServers);
    }
}

