/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.annotation.NoColumn;
import cool.scx.base.AbstractFilter;
import cool.scx.base.BaseModel;
import cool.scx.base.Query;
import cool.scx.base.SelectFilter;
import cool.scx.dao.ScxDaoTableInfo;
import cool.scx.ext.crud.exception.EmptySelectColumn;
import cool.scx.ext.crud.exception.PaginationParametersError;
import cool.scx.ext.crud.exception.UnknownFieldName;
import cool.scx.ext.crud.exception.UnknownFilterMode;
import cool.scx.ext.crud.exception.UnknownSortType;
import cool.scx.ext.crud.exception.UnknownWhereType;
import cool.scx.ext.crud.exception.WhereBodyParametersSizeError;
import cool.scx.http.exception.impl.BadRequestException;
import cool.scx.sql.order_by.OrderByOption;
import cool.scx.sql.order_by.OrderByType;
import cool.scx.sql.where.WhereOption;
import cool.scx.sql.where.WhereType;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public final class CRUDListParam {
    public CRUDPagination pagination;
    public List<CRUDOrderByBody> orderByBodyList;
    public List<CRUDWhereBody> whereBodyList;
    public CRUDSelectFilterBody selectFilterBody;

    public static void checkFieldName(Class<?> modelClass, String fieldName) throws UnknownFieldName {
        try {
            Field field = modelClass.getField(fieldName);
            if (field.isAnnotationPresent(NoColumn.class)) {
                throw new UnknownFieldName(fieldName);
            }
        }
        catch (Exception e) {
            throw new UnknownFieldName(fieldName);
        }
    }

    public static WhereType checkWhereType(String fieldName, String strWhereType) throws UnknownWhereType {
        try {
            return WhereType.of((String)strWhereType);
        }
        catch (Exception ignored) {
            throw new UnknownWhereType(fieldName, strWhereType);
        }
    }

    public static OrderByType checkSortType(String fieldName, String strSortType) throws UnknownSortType {
        try {
            return OrderByType.of((String)strSortType);
        }
        catch (Exception ignored) {
            throw new UnknownSortType(fieldName, strSortType);
        }
    }

    public static void checkWhereBodyParametersSize(String fieldName, WhereType whereType, Object value1, Object value2) throws WhereBodyParametersSizeError {
        AtomicInteger paramSize = new AtomicInteger();
        if (value1 != null) {
            paramSize.set(paramSize.get() + 1);
        }
        if (value2 != null) {
            paramSize.set(paramSize.get() + 1);
        }
        if (whereType.paramSize() != paramSize.get()) {
            throw new WhereBodyParametersSizeError(fieldName, whereType, paramSize.get());
        }
    }

    public static AbstractFilter.FilterMode checkFilterMode(String filterMode) throws UnknownWhereType {
        try {
            return AbstractFilter.FilterMode.of((String)filterMode);
        }
        catch (Exception ignored) {
            throw new UnknownFilterMode(filterMode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkPagination(Query query, CRUDPagination crudPagination) {
        Integer pageSize = crudPagination.pageSize;
        Integer currentPage = crudPagination.currentPage;
        if (pageSize == null) return;
        if (pageSize < 0) throw new PaginationParametersError(currentPage, pageSize);
        if (currentPage == null) {
            query.setPagination(pageSize);
            return;
        } else {
            if (currentPage < 0) throw new PaginationParametersError(currentPage, pageSize);
            query.setPagination(currentPage, pageSize);
        }
    }

    public Query getQuery(Class<? extends BaseModel> modelClass) throws BadRequestException {
        Query query = new Query();
        if (this.pagination != null) {
            CRUDListParam.checkPagination(query, this.pagination);
        }
        if (this.orderByBodyList != null) {
            for (CRUDOrderByBody orderByBody : this.orderByBodyList) {
                if (orderByBody.fieldName == null || orderByBody.sortType == null) continue;
                CRUDListParam.checkFieldName(modelClass, orderByBody.fieldName);
                OrderByType sortType = CRUDListParam.checkSortType(orderByBody.fieldName, orderByBody.sortType);
                query.orderBy().add(orderByBody.fieldName, sortType, new OrderByOption[0]);
            }
        }
        if (this.whereBodyList != null) {
            for (CRUDWhereBody crudWhereBody : this.whereBodyList) {
                if (crudWhereBody.fieldName == null || crudWhereBody.whereType == null) continue;
                CRUDListParam.checkFieldName(modelClass, crudWhereBody.fieldName);
                WhereType whereType = CRUDListParam.checkWhereType(crudWhereBody.fieldName, crudWhereBody.whereType);
                CRUDListParam.checkWhereBodyParametersSize(crudWhereBody.fieldName, whereType, crudWhereBody.value1, crudWhereBody.value2);
                if (whereType.paramSize() == 0) {
                    query.where().add0(crudWhereBody.fieldName, whereType, new WhereOption[0]);
                    continue;
                }
                if (whereType.paramSize() == 1) {
                    query.where().add1(crudWhereBody.fieldName, whereType, crudWhereBody.value1, new WhereOption[0]);
                    continue;
                }
                if (whereType.paramSize() != 2) continue;
                query.where().add2(crudWhereBody.fieldName, whereType, crudWhereBody.value1, crudWhereBody.value2, new WhereOption[0]);
            }
        }
        return query;
    }

    public SelectFilter getSelectFilter(Class<? extends BaseModel> modelClass, ScxDaoTableInfo scxDaoTableInfo) {
        SelectFilter selectFilter;
        if (this.selectFilterBody == null) {
            return SelectFilter.ofExcluded();
        }
        AbstractFilter.FilterMode filterMode = CRUDListParam.checkFilterMode(this.selectFilterBody.filterMode);
        switch (filterMode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EXCLUDED: {
                SelectFilter selectFilter2 = SelectFilter.ofExcluded();
                break;
            }
            case INCLUDED: {
                SelectFilter selectFilter2 = selectFilter = SelectFilter.ofIncluded();
            }
        }
        if (this.selectFilterBody.fieldNames != null) {
            for (String fieldName : this.selectFilterBody.fieldNames) {
                CRUDListParam.checkFieldName(modelClass, fieldName);
                selectFilter.add(new String[]{fieldName});
            }
        }
        if (selectFilter.filter(scxDaoTableInfo.columnInfos()).length == 0) {
            throw new EmptySelectColumn(filterMode, this.selectFilterBody.fieldNames);
        }
        return selectFilter;
    }

    public static final class CRUDPagination {
        public Integer currentPage;
        public Integer pageSize;
    }

    public static final class CRUDOrderByBody {
        public String fieldName;
        public String sortType;
    }

    public static final class CRUDWhereBody {
        public String fieldName;
        public String whereType;
        public Object value1;
        public Object value2;

        public CRUDWhereBody() {
        }

        public CRUDWhereBody(String fieldName, String whereType, Object value1, Object value2) {
            this.fieldName = fieldName;
            this.whereType = whereType;
            this.value1 = value1;
            this.value2 = value2;
        }
    }

    public static final class CRUDSelectFilterBody {
        public String filterMode;
        public String[] fieldNames;
    }
}

