/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import com.google.common.collect.ArrayListMultimap;
import cool.scx.ScxContext;
import cool.scx.ScxModuleMetadata;
import cool.scx.base.BaseModel;
import cool.scx.base.BaseModelService;
import cool.scx.ext.crud.annotation.NoCRUD;
import cool.scx.ext.crud.exception.UnknownCRUDModelException;
import cool.scx.http.exception.impl.BadRequestException;
import cool.scx.util.ObjectUtils;
import cool.scx.util.StringUtils;
import cool.scx.util.ansi.Ansi;
import cool.scx.util.ansi.AnsiElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CRUDHelper {
    private static final Logger logger = LoggerFactory.getLogger(CRUDHelper.class);
    private static final Map<String, Class<BaseModel>> BASE_MODEL_NAME_CLASS_MAPPING = CRUDHelper.initBaseModelNameClassMapping();
    private static final Map<Class<BaseModel>, Class<BaseModelService<BaseModel>>> BASE_MODEL_CLASS_BASE_SERVICE_CLASS_MAPPING = CRUDHelper.initBaseModelClassBaseModelServiceClassMapping();
    private static final Map<Class<BaseModel>, BaseModelService<BaseModel>> BASE_MODEL_CLASS_BASE_MODEL_SERVICE_CACHE = new HashMap<Class<BaseModel>, BaseModelService<BaseModel>>();

    public static BaseModelService<BaseModel> getBaseModelService(Class<BaseModel> baseModelClass) {
        BaseModelService baseModelService = BASE_MODEL_CLASS_BASE_MODEL_SERVICE_CACHE.get(baseModelClass);
        if (baseModelService == null) {
            Class<BaseModelService<BaseModel>> baseModelServiceClass = BASE_MODEL_CLASS_BASE_SERVICE_CLASS_MAPPING.get(baseModelClass);
            baseModelService = baseModelServiceClass != null ? (BaseModelService)ScxContext.getBean(baseModelServiceClass) : new BaseModelService(baseModelClass);
            BASE_MODEL_CLASS_BASE_MODEL_SERVICE_CACHE.put(baseModelClass, (BaseModelService<BaseModel>)baseModelService);
        }
        return baseModelService;
    }

    public static <B extends BaseModel> B mapToBaseModel(Map<String, Object> entityMap, Class<B> baseModelClass) {
        try {
            return (B)((BaseModel)ObjectUtils.convertValue(entityMap, baseModelClass));
        }
        catch (Exception e) {
            logger.error("\u5c06 Map \u8f6c\u6362\u4e3a BaseModel \u65f6\u53d1\u751f\u5f02\u5e38 : ", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
    }

    public static Class<BaseModel> getBaseModelClass(String baseModelName) throws UnknownCRUDModelException {
        if (StringUtils.isBlank((String)baseModelName)) {
            throw new UnknownCRUDModelException(baseModelName);
        }
        Class<BaseModel> baseModelClass = BASE_MODEL_NAME_CLASS_MAPPING.get(baseModelName.toLowerCase());
        if (baseModelClass == null) {
            throw new UnknownCRUDModelException(baseModelName);
        }
        return baseModelClass;
    }

    private static Map<String, Class<BaseModel>> initBaseModelNameClassMapping() {
        HashMap<String, Class<BaseModel>> tempMap = new HashMap<String, Class<BaseModel>>();
        for (ScxModuleMetadata m : ScxContext.scxModuleMetadataList()) {
            for (Class c : m.scxBaseModelClassList()) {
                NoCRUD noCRUDAnnotation = c.getAnnotation(NoCRUD.class);
                if (noCRUDAnnotation != null) continue;
                String className = c.getSimpleName().toLowerCase();
                Class<BaseModel> aClass = tempMap.get(className);
                tempMap.put(className, c);
                if (aClass == null) continue;
                Ansi.out().brightRed((Object)"\u68c0\u6d4b\u5230\u91cd\u590d\u540d\u79f0\u7684 BaseModel ", new AnsiElement[0]).brightYellow((Object)("[" + aClass.getName() + "] "), new AnsiElement[0]).blue((Object)("[" + c.getName() + "]"), new AnsiElement[0]).brightRed((Object)" \u53ef\u80fd\u4f1a\u5bfc\u81f4\u6839\u636e\u540d\u79f0\u8c03\u7528\u65f6\u610f\u4e49\u4e0d\u660e\u786e !!! \u5efa\u8bae\u4fee\u6539 !!!", new AnsiElement[0]).println();
            }
        }
        return tempMap;
    }

    private static Map<Class<BaseModel>, Class<BaseModelService<BaseModel>>> initBaseModelClassBaseModelServiceClassMapping() {
        ArrayListMultimap classClassHashSetValuedHashMap = ArrayListMultimap.create();
        Collection<Class<BaseModel>> baseModelClassList = BASE_MODEL_NAME_CLASS_MAPPING.values();
        for (ScxModuleMetadata m : ScxContext.scxModuleMetadataList()) {
            for (Class c : m.scxBaseModelServiceClassList()) {
                Type[] typeArguments = ((ParameterizedType)c.getGenericSuperclass()).getActualTypeArguments();
                Class baseModelClass = (Class)typeArguments[0];
                if (!baseModelClassList.contains(baseModelClass)) continue;
                classClassHashSetValuedHashMap.put((Object)baseModelClass, (Object)c);
            }
        }
        HashMap<Class<BaseModel>, Class<BaseModelService<BaseModel>>> tempMap = new HashMap<Class<BaseModel>, Class<BaseModelService<BaseModel>>>();
        for (Class key : classClassHashSetValuedHashMap.keySet()) {
            List classes = classClassHashSetValuedHashMap.get((Object)key);
            Class lastThisBaseModelClassBaseModelServiceClass = (Class)classes.get(classes.size() - 1);
            if (classes.size() > 1) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < classes.size() - 1; ++i) {
                    String name = ((Class)classes.get(i)).getName();
                    if (i == classes.size() - 2) {
                        sb.append("[").append(name).append("] ");
                        continue;
                    }
                    sb.append("[").append(name).append("],");
                }
                Ansi.out().brightRed((Object)("\u68c0\u6d4b\u5230\u9488\u5bf9 " + key.getName() + " \u7684\u591a\u4e2a BaseModelService \u5b9e\u73b0 , \u5df2\u91c7\u7528\u6700\u540e\u4e00\u4e2a [" + lastThisBaseModelClassBaseModelServiceClass.getName() + "] ,"), new AnsiElement[0]).brightYellow((Object)(" \u5176\u4f59\u7684 BaseModelService \u5b9e\u73b0 " + sb), new AnsiElement[0]).println();
            }
            tempMap.put(key, lastThisBaseModelClassBaseModelServiceClass);
        }
        return tempMap;
    }
}

