/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.fss;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import cool.scx.ScxContext;
import cool.scx.base.Query;
import cool.scx.ext.fss.FSSConfig;
import cool.scx.ext.fss.FSSObject;
import cool.scx.ext.fss.FSSObjectService;
import cool.scx.http.exception.impl.NotFoundException;
import cool.scx.sql.where.WhereOption;
import cool.scx.type.UploadedEntity;
import cool.scx.util.FileUtils;
import cool.scx.util.RandomUtils;
import cool.scx.util.digest.DigestUtils;
import cool.scx.vo.BaseVo;
import cool.scx.vo.DataJson;
import cool.scx.vo.Download;
import cool.scx.vo.Image;
import cool.scx.vo.Json;
import cool.scx.vo.Raw;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class FSSHandler {
    private static final Cache<String, Image> IMAGE_CACHE = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(1L, TimeUnit.DAYS).concurrencyLevel(Runtime.getRuntime().availableProcessors()).build();
    private final FSSObjectService fssObjectService;

    public FSSHandler(FSSObjectService fssObjectService) {
        this.fssObjectService = fssObjectService;
    }

    public FSSHandler() {
        this.fssObjectService = (FSSObjectService)((Object)ScxContext.getBean(FSSObjectService.class));
    }

    public static Integer getLastUploadChunk(Path uploadConfigFile, Integer chunkLength) throws IOException {
        try {
            String allStr = Files.readString(uploadConfigFile);
            return Integer.parseInt(allStr.split("_")[0]);
        }
        catch (Exception e) {
            FSSHandler.updateLastUploadChunk(uploadConfigFile, -1, chunkLength);
            return -1;
        }
    }

    public static void updateLastUploadChunk(Path uploadConfigFile, Integer nowChunkIndex, Integer chunkLength) throws IOException {
        Files.createDirectories(uploadConfigFile.getParent(), new FileAttribute[0]);
        Files.writeString(uploadConfigFile, (CharSequence)(nowChunkIndex + "_" + chunkLength), new OpenOption[0]);
    }

    public static FSSObject createFSSObjectByFileInfo(String fileName, Long fileSize, String fileMD5) {
        LocalDateTime now = LocalDateTime.now();
        String yearStr = "" + now.getYear();
        String monthStr = "" + now.getMonthValue();
        String dayStr = "" + now.getDayOfMonth();
        FSSObject fssObject = new FSSObject();
        fssObject.fssObjectID = RandomUtils.getUUID();
        fssObject.fileName = fileName;
        fssObject.uploadTime = now;
        fssObject.fileSizeDisplay = FileUtils.longToDisplaySize((long)fileSize);
        fssObject.fileSize = fileSize;
        fssObject.fileMD5 = fileMD5;
        fssObject.fileExtension = FileUtils.getExt((String)fssObject.fileName);
        fssObject.filePath = new String[]{yearStr, monthStr, dayStr, fileMD5, fileName};
        return fssObject;
    }

    public static Path getUploadTempPath(String fileMD5) {
        return FSSConfig.uploadFilePath().resolve("TEMP").resolve(fileMD5);
    }

    public static Path getPhysicalFilePath(FSSObject fssObject) {
        return Path.of(FSSConfig.uploadFilePath().toString(), fssObject.filePath);
    }

    public FSSObject copyFSSObject(String fileName, FSSObject oldFSSObject) {
        FSSObject fssObject = new FSSObject();
        fssObject.fssObjectID = RandomUtils.getUUID();
        fssObject.fileName = fileName;
        fssObject.uploadTime = LocalDateTime.now();
        fssObject.filePath = oldFSSObject.filePath;
        fssObject.fileSizeDisplay = oldFSSObject.fileSizeDisplay;
        fssObject.fileSize = oldFSSObject.fileSize;
        fssObject.fileMD5 = oldFSSObject.fileMD5;
        fssObject.fileExtension = FileUtils.getExt((String)fssObject.fileName);
        return fssObject;
    }

    public FSSObject checkFSSObjectID(String fssObjectID) {
        FSSObject fssObject = this.fssObjectService.findByFSSObjectID(fssObjectID);
        if (fssObject == null) {
            throw new NotFoundException();
        }
        return fssObject;
    }

    public File checkPhysicalFile(FSSObject fssObject) throws NotFoundException {
        File physicalFile = FSSHandler.getPhysicalFilePath(fssObject).toFile();
        if (!physicalFile.exists()) {
            throw new NotFoundException();
        }
        return physicalFile;
    }

    public Download download(String fssObjectID) {
        FSSObject fssObject = this.checkFSSObjectID(fssObjectID);
        File file = this.checkPhysicalFile(fssObject);
        return new Download(file, fssObject.fileName);
    }

    public Image image(String fssObjectID, Integer width, Integer height, String type) {
        String cacheKey = fssObjectID + " " + width + " " + height + " " + type;
        Image image = (Image)IMAGE_CACHE.getIfPresent((Object)cacheKey);
        if (image == null) {
            FSSObject fssObject = this.checkFSSObjectID(fssObjectID);
            File file = this.checkPhysicalFile(fssObject);
            image = new Image(file, width, height, type);
            IMAGE_CACHE.put((Object)cacheKey, (Object)image);
        }
        return image;
    }

    public Raw raw(String fssObjectID) {
        FSSObject fssObject = this.checkFSSObjectID(fssObjectID);
        File file = this.checkPhysicalFile(fssObject);
        return new Raw(file);
    }

    public Json upload(String fileName, Long fileSize, String fileMD5, Integer chunkLength, Integer nowChunkIndex, UploadedEntity fileData) throws IOException {
        Path uploadTempFile = FSSHandler.getUploadTempPath(fileMD5).resolve("scx_fss.temp");
        Path uploadConfigFile = uploadTempFile.resolveSibling("scx_fss.upload_state");
        if (nowChunkIndex == chunkLength - 1) {
            FileUtils.fileAppend((Path)uploadTempFile, (byte[])fileData.buffer().getBytes());
            FSSObject newFSSObject = FSSHandler.createFSSObjectByFileInfo(fileName, fileSize, fileMD5);
            Path fileStoragePath = Path.of(FSSConfig.uploadFilePath().toString(), newFSSObject.filePath);
            String serverMd5Str = DigestUtils.md5((File)uploadTempFile.toFile());
            if (!fileMD5.equalsIgnoreCase(serverMd5Str)) {
                FileUtils.deleteFiles((Path)uploadTempFile.getParent());
                return Json.fail((String)"upload-fail");
            }
            boolean renameSuccess = FileUtils.fileMove((Path)uploadTempFile, (Path)fileStoragePath);
            if (renameSuccess) {
                FileUtils.deleteFiles((Path)uploadTempFile.getParent());
                FSSObject save = (FSSObject)this.fssObjectService.save(newFSSObject);
                return Json.ok().put("type", (Object)"upload-success").put("item", (Object)save);
            }
            return Json.fail((String)"upload-fail");
        }
        Integer lastUploadChunk = FSSHandler.getLastUploadChunk(uploadConfigFile, chunkLength);
        int needUploadChunkIndex = lastUploadChunk + 1;
        if (nowChunkIndex.equals(needUploadChunkIndex)) {
            FileUtils.fileAppend((Path)uploadTempFile, (byte[])fileData.buffer().getBytes());
            FSSHandler.updateLastUploadChunk(uploadConfigFile, nowChunkIndex, chunkLength);
            return Json.ok().put("type", (Object)"need-more").put("item", (Object)(needUploadChunkIndex + 1));
        }
        return Json.ok().put("type", (Object)"need-more").put("item", (Object)needUploadChunkIndex);
    }

    public Json delete(String fssObjectIDs) {
        FSSObject needDeleteFile = (FSSObject)this.fssObjectService.get(new Query().equal("fssObjectID", (Object)fssObjectIDs, new WhereOption[0]));
        if (needDeleteFile != null) {
            Path filePath;
            long count = this.fssObjectService.count(new Query().equal("fileMD5", (Object)needDeleteFile.fileMD5, new WhereOption[0]));
            if (count <= 1L && Files.exists(filePath = Path.of(FSSConfig.uploadFilePath().toString(), needDeleteFile.filePath), new LinkOption[0]) && !FileUtils.deleteFiles((Path)filePath.getParent())) {
                return Json.fail();
            }
            this.fssObjectService.delete(new long[]{needDeleteFile.id});
        }
        return Json.ok();
    }

    public BaseVo listInfo(List<String> fssObjectIDs) {
        if (fssObjectIDs != null && fssObjectIDs.size() > 0) {
            return DataJson.ok().data(this.fssObjectService.findByFSSObjectIDs(fssObjectIDs));
        }
        return DataJson.ok().data(new ArrayList());
    }

    public BaseVo info(String fssObjectID) {
        if (fssObjectID != null) {
            return DataJson.ok().data((Object)this.fssObjectService.findByFSSObjectID(fssObjectID));
        }
        return DataJson.ok().data(null);
    }

    public Json checkAnyFileExistsByThisMD5(String fileName, Long fileSize, String fileMD5) throws IOException {
        List<FSSObject> fssObjectListByMd5 = this.fssObjectService.findFSSObjectListByMd5(fileMD5);
        if (fssObjectListByMd5 != null && fssObjectListByMd5.size() > 0) {
            FSSObject canUseFssObject = null;
            for (FSSObject fssObject : fssObjectListByMd5) {
                File physicalFile = FSSHandler.getPhysicalFilePath(fssObject).toFile();
                if (!physicalFile.exists() || physicalFile.length() != fileSize.longValue() || !fileMD5.equalsIgnoreCase(DigestUtils.md5((File)physicalFile))) continue;
                canUseFssObject = fssObject;
                break;
            }
            if (canUseFssObject != null) {
                FSSObject save = (FSSObject)this.fssObjectService.save(this.copyFSSObject(fileName, canUseFssObject));
                FileUtils.deleteFiles((Path)FSSHandler.getUploadTempPath(fileMD5));
                return Json.ok().put("type", (Object)"upload-by-md5-success").put("item", (Object)save);
            }
        }
        return Json.fail((String)"no-any-file-exists-for-this-md5");
    }
}

