/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.ws;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.ext.ws.WSContext;
import cool.scx.ext.ws.WSMessage;
import cool.scx.mvc.annotation.ScxWebSocketMapping;
import cool.scx.mvc.base.BaseWebSocketHandler;
import cool.scx.mvc.websocket.OnCloseRoutingContext;
import cool.scx.mvc.websocket.OnExceptionRoutingContext;
import cool.scx.mvc.websocket.OnFrameRoutingContext;
import cool.scx.mvc.websocket.OnOpenRoutingContext;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScxWebSocketMapping(value="/scx")
public class WSWebSocketHandler
implements BaseWebSocketHandler {
    public static final String LOVE = "\u2764";
    private static final Logger logger = LoggerFactory.getLogger(WSWebSocketHandler.class);

    public void onOpen(ServerWebSocket webSocket, OnOpenRoutingContext ctx) {
        WSContext.wsOnlineClientTable().add(webSocket);
        logger.debug("{} \u8fde\u63a5\u4e86!!! \u5f53\u524d\u603b\u8fde\u63a5\u6570 : {}", (Object)webSocket.binaryHandlerID(), (Object)WSContext.wsOnlineClientTable().size());
        ctx.next();
    }

    public void onClose(ServerWebSocket webSocket, OnCloseRoutingContext ctx) {
        WSContext.wsOnlineClientTable().remove(webSocket);
        logger.debug("{} \u5173\u95ed\u4e86!!! \u5f53\u524d\u603b\u8fde\u63a5\u6570 : {}", (Object)webSocket.binaryHandlerID(), (Object)WSContext.wsOnlineClientTable().size());
        ctx.next();
    }

    public void onTextMessage(String textData, WebSocketFrame h, ServerWebSocket webSocket, OnFrameRoutingContext ctx) throws JsonProcessingException {
        if (LOVE.equals(textData)) {
            webSocket.writeTextMessage(LOVE);
        } else {
            WSContext.wsEventBus().publishByWSMessage(WSMessage.fromJson(textData).setWebSocket(webSocket));
        }
        ctx.next();
    }

    public void onError(Throwable event, ServerWebSocket webSocket, OnExceptionRoutingContext ctx) {
        WSContext.wsOnlineClientTable().remove(webSocket);
        event.printStackTrace();
        ctx.next();
    }
}

