/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.fss;

import cool.scx.enumeration.HttpMethod;
import cool.scx.ext.fss.FSSConfig;
import cool.scx.ext.fss.FSSObject;
import cool.scx.ext.fss.FSSObjectService;
import cool.scx.mvc.annotation.FromBody;
import cool.scx.mvc.annotation.FromPath;
import cool.scx.mvc.annotation.FromQuery;
import cool.scx.mvc.annotation.FromUpload;
import cool.scx.mvc.annotation.ScxMapping;
import cool.scx.mvc.exception.InternalServerErrorException;
import cool.scx.mvc.exception.NotFoundException;
import cool.scx.mvc.type.UploadedEntity;
import cool.scx.mvc.vo.BaseVo;
import cool.scx.mvc.vo.DataJson;
import cool.scx.mvc.vo.Download;
import cool.scx.mvc.vo.Image;
import cool.scx.mvc.vo.Json;
import cool.scx.mvc.vo.Raw;
import cool.scx.util.Cache;
import cool.scx.util.DigestUtils;
import cool.scx.util.FileUtils;
import cool.scx.util.RandomUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@ScxMapping(value="/api/fss")
public class FSSController {
    private static final Cache<String, Image> IMAGE_CACHE = new Cache(10000);
    private final FSSObjectService fssObjectService;

    public FSSController(FSSObjectService fssObjectService) {
        this.fssObjectService = fssObjectService;
    }

    private static Path checkPhysicalFile(FSSObject fssObject) throws NotFoundException {
        Path physicalFile = FSSObjectService.getPhysicalFilePath(fssObject);
        if (Files.notExists(physicalFile, new LinkOption[0])) {
            throw new NotFoundException();
        }
        return physicalFile;
    }

    private static Path getUploadTempPath(String fileMD5) {
        return FSSConfig.uploadFilePath().resolve("TEMP").resolve(fileMD5);
    }

    public static FSSObject copyFSSObject(String fileName, FSSObject oldFSSObject) {
        FSSObject fssObject = new FSSObject();
        fssObject.fssObjectID = RandomUtils.randomUUID();
        fssObject.fileName = fileName;
        fssObject.uploadTime = LocalDateTime.now();
        fssObject.filePath = oldFSSObject.filePath;
        fssObject.fileSizeDisplay = oldFSSObject.fileSizeDisplay;
        fssObject.fileSize = oldFSSObject.fileSize;
        fssObject.fileMD5 = oldFSSObject.fileMD5;
        fssObject.fileExtension = FileUtils.getExtension((String)fssObject.fileName);
        return fssObject;
    }

    public static FSSObject createFSSObjectByFileInfo(String fileName, Long fileSize, String fileMD5) {
        LocalDateTime now = LocalDateTime.now();
        String yearStr = "" + now.getYear();
        String monthStr = "" + now.getMonthValue();
        String dayStr = "" + now.getDayOfMonth();
        FSSObject fssObject = new FSSObject();
        fssObject.fssObjectID = RandomUtils.randomUUID();
        fssObject.fileName = fileName;
        fssObject.uploadTime = now;
        fssObject.fileSizeDisplay = FileUtils.longToDisplaySize((long)fileSize);
        fssObject.fileSize = fileSize;
        fssObject.fileMD5 = fileMD5;
        fssObject.fileExtension = FileUtils.getExtension((String)fssObject.fileName);
        fssObject.filePath = new String[]{yearStr, monthStr, dayStr, fileMD5, fileName};
        return fssObject;
    }

    public static Integer getLastUploadChunk(Path uploadConfigFile, Integer chunkLength) throws IOException {
        try {
            String allStr = Files.readString(uploadConfigFile);
            return Integer.parseInt(allStr.split("_")[0]);
        }
        catch (Exception e) {
            FSSController.updateLastUploadChunk(uploadConfigFile, -1, chunkLength);
            return -1;
        }
    }

    public static void updateLastUploadChunk(Path uploadConfigFile, Integer nowChunkIndex, Integer chunkLength) throws IOException {
        String str = nowChunkIndex + "_" + chunkLength;
        FileUtils.write((Path)uploadConfigFile, (byte[])str.getBytes(StandardCharsets.UTF_8), (OpenOption[])new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.SYNC, StandardOpenOption.WRITE});
    }

    @ScxMapping(value="/download/:fssObjectID", method={HttpMethod.GET, HttpMethod.HEAD})
    public Download download(@FromPath String fssObjectID) {
        FSSObject fssObject = this.checkFSSObjectID(fssObjectID);
        Path file = FSSController.checkPhysicalFile(fssObject);
        return Download.of((Path)file, (String)fssObject.fileName);
    }

    @ScxMapping(value="/image/:fssObjectID", method={HttpMethod.GET, HttpMethod.HEAD})
    public Image image(@FromPath String fssObjectID, @FromQuery(value="w", required=false) Integer width, @FromQuery(value="h", required=false) Integer height, @FromQuery(value="t", required=false) String type) {
        String cacheKey = fssObjectID + " " + width + " " + height + " " + type;
        return (Image)IMAGE_CACHE.computeIfAbsent((Object)cacheKey, k -> {
            FSSObject fssObject = this.checkFSSObjectID(fssObjectID);
            Path file = FSSController.checkPhysicalFile(fssObject);
            return Image.of((File)file.toFile(), (Integer)width, (Integer)height, (String)type);
        });
    }

    @ScxMapping(value="/raw/:fssObjectID", method={HttpMethod.GET, HttpMethod.HEAD})
    public Raw raw(@FromPath String fssObjectID) {
        FSSObject fssObject = this.checkFSSObjectID(fssObjectID);
        Path file = FSSController.checkPhysicalFile(fssObject);
        return Raw.of((Path)file);
    }

    @ScxMapping(value="/upload", method={HttpMethod.POST})
    public Json upload(@FromBody String fileName, @FromBody Long fileSize, @FromBody String fileMD5, @FromBody Integer chunkLength, @FromBody Integer nowChunkIndex, @FromUpload UploadedEntity fileData) throws Exception {
        Path uploadTempFile = FSSController.getUploadTempPath(fileMD5).resolve("scx_fss.temp");
        Path uploadConfigFile = uploadTempFile.resolveSibling("scx_fss.upload_state");
        if (nowChunkIndex == chunkLength - 1) {
            FileUtils.write((Path)uploadTempFile, (byte[])fileData.buffer().getBytes(), (OpenOption[])new OpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.SYNC, StandardOpenOption.WRITE});
            FSSObject newFSSObject = FSSController.createFSSObjectByFileInfo(fileName, fileSize, fileMD5);
            Path fileStoragePath = Path.of(FSSConfig.uploadFilePath().toString(), newFSSObject.filePath);
            String serverMd5Str = DigestUtils.md5((File)uploadTempFile.toFile());
            if (!fileMD5.equalsIgnoreCase(serverMd5Str)) {
                FileUtils.delete((Path)uploadTempFile.getParent(), (FileUtils.DeleteOption[])new FileUtils.DeleteOption[0]);
                throw new InternalServerErrorException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25 : MD5 \u6821\u9a8c\u5931\u8d25 , \u6587\u4ef6 : " + fileMD5);
            }
            FileUtils.move((Path)uploadTempFile, (Path)fileStoragePath, (CopyOption[])new CopyOption[0]);
            fileStoragePath.toFile().setReadOnly();
            FileUtils.delete((Path)uploadTempFile.getParent(), (FileUtils.DeleteOption[])new FileUtils.DeleteOption[0]);
            FSSObject save = (FSSObject)this.fssObjectService.add(newFSSObject);
            return Json.ok().put("type", (Object)"upload-success").put("item", (Object)save);
        }
        Integer lastUploadChunk = FSSController.getLastUploadChunk(uploadConfigFile, chunkLength);
        int needUploadChunkIndex = lastUploadChunk + 1;
        if (nowChunkIndex.equals(needUploadChunkIndex)) {
            FileUtils.write((Path)uploadTempFile, (byte[])fileData.buffer().getBytes(), (OpenOption[])new OpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.SYNC, StandardOpenOption.WRITE});
            FSSController.updateLastUploadChunk(uploadConfigFile, nowChunkIndex, chunkLength);
            return Json.ok().put("type", (Object)"need-more").put("item", (Object)(needUploadChunkIndex + 1));
        }
        return Json.ok().put("type", (Object)"need-more").put("item", (Object)needUploadChunkIndex);
    }

    @ScxMapping(value="/delete", method={HttpMethod.DELETE})
    public Json delete(@FromBody String fssObjectID) throws IOException {
        this.fssObjectService.delete(fssObjectID);
        return Json.ok();
    }

    @ScxMapping(value="check-any-file-exists-by-this-md5", method={HttpMethod.POST})
    public Json checkAnyFileExistsByThisMD5(@FromBody String fileName, @FromBody Long fileSize, @FromBody String fileMD5) throws IOException {
        List<FSSObject> fssObjectListByMd5 = this.fssObjectService.findFSSObjectListByMD5(fileMD5);
        if (fssObjectListByMd5.size() > 0) {
            FSSObject canUseFssObject = null;
            for (FSSObject fssObject : fssObjectListByMd5) {
                File physicalFile = FSSObjectService.getPhysicalFilePath(fssObject).toFile();
                if (!physicalFile.exists() || physicalFile.length() != fileSize.longValue() || !fileMD5.equalsIgnoreCase(DigestUtils.md5((File)physicalFile))) continue;
                canUseFssObject = fssObject;
                break;
            }
            if (canUseFssObject != null) {
                FSSObject save = (FSSObject)this.fssObjectService.add(FSSController.copyFSSObject(fileName, canUseFssObject));
                FileUtils.delete((Path)FSSController.getUploadTempPath(fileMD5), (FileUtils.DeleteOption[])new FileUtils.DeleteOption[0]);
                return Json.ok().put("type", (Object)"upload-by-md5-success").put("item", (Object)save);
            }
        }
        return Json.fail((String)"no-any-file-exists-for-this-md5");
    }

    @ScxMapping(value="/info", method={HttpMethod.POST})
    public BaseVo info(@FromBody String fssObjectID) {
        if (fssObjectID != null) {
            return DataJson.ok().data((Object)this.fssObjectService.findByFSSObjectID(fssObjectID));
        }
        return DataJson.ok().data(null);
    }

    @ScxMapping(value="/list-info", method={HttpMethod.POST})
    public BaseVo listInfo(@FromBody List<String> fssObjectIDs) {
        if (fssObjectIDs != null && fssObjectIDs.size() > 0) {
            return DataJson.ok().data(this.fssObjectService.findByFSSObjectIDs(fssObjectIDs));
        }
        return DataJson.ok().data(new ArrayList());
    }

    private FSSObject checkFSSObjectID(String fssObjectID) {
        FSSObject fssObject = this.fssObjectService.findByFSSObjectID(fssObjectID);
        if (fssObject == null) {
            throw new NotFoundException();
        }
        return fssObject;
    }
}

