/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.static_server;

import cool.scx.config.ScxConfigValueHandler;
import cool.scx.core.Scx;
import cool.scx.core.ScxContext;
import cool.scx.core.ScxModule;
import cool.scx.ext.static_server.ConvertStaticServerHandler;
import cool.scx.ext.static_server.SingleFileStaticHandlerImpl;
import cool.scx.ext.static_server.StaticServer;
import cool.scx.util.ScxExceptionHelper;
import io.vertx.core.Handler;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.FileSystemAccess;
import io.vertx.ext.web.handler.StaticHandler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticServerModule
extends ScxModule {
    private static final Logger logger = LoggerFactory.getLogger(StaticServerModule.class);

    private static List<StaticServer> getStaticServersByConfig() {
        return (List)ScxContext.config().get("static-servers", (ScxConfigValueHandler)new ConvertStaticServerHandler(ScxContext.environment()));
    }

    private static void registerStaticServerHandler(Router vertxRouter, List<StaticServer> staticServers) {
        for (StaticServer staticServer : staticServers) {
            Boolean isRegularFile = (Boolean)ScxExceptionHelper.ignore(() -> Files.isRegularFile(staticServer.root(), new LinkOption[0]), (Object)true);
            if (isRegularFile.booleanValue()) {
                vertxRouter.route(staticServer.location()).handler((Handler)new SingleFileStaticHandlerImpl(staticServer.root()));
                continue;
            }
            vertxRouter.route(staticServer.location()).handler((Handler)StaticHandler.create((FileSystemAccess)FileSystemAccess.ROOT, (String)staticServer.root().toString()).setFilesReadOnly(false));
        }
    }

    public void start(Scx scx) {
        List<StaticServer> staticServers = StaticServerModule.getStaticServersByConfig();
        logger.info("\u9759\u6001\u8d44\u6e90\u670d\u52a1\u5668 -->  {}", (Object)staticServers.stream().map(StaticServer::location).collect(Collectors.joining(", ", "[", "]")));
        StaticServerModule.registerStaticServerHandler((Router)ScxContext.router(), staticServers);
    }

    public String name() {
        return "SCX_EXT-" + super.name();
    }
}

