/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.auth;

import cool.scx.core.Scx;
import cool.scx.core.ScxContext;
import cool.scx.core.ScxModule;
import cool.scx.ext.auth.ApiPermsInterceptor;
import cool.scx.ext.auth.BaseAuthHandler;
import cool.scx.ext.auth.ScxAuthCookieHandler;
import cool.scx.ext.ws.WSContext;
import cool.scx.mvc.ScxMvcInterceptor;
import io.vertx.core.Handler;

public class AuthModule
extends ScxModule {
    public static String BIND_WEBSOCKET_BY_TOKEN = "bind-websocket-by-token";

    public static void init(Scx scx) {
        BaseAuthHandler authHandler = (BaseAuthHandler)ScxContext.getBean(BaseAuthHandler.class);
        WSContext.wsConsumer(BIND_WEBSOCKET_BY_TOKEN, authHandler::bindWebSocketByToken);
        scx.scxMvc().setInterceptor((ScxMvcInterceptor)new ApiPermsInterceptor(authHandler));
        scx.scxHttpRouter().corsHandler().allowedHeader("S-Token").allowedHeader("S-Device");
        scx.scxHttpRouter().route().order(1).handler((Handler)new ScxAuthCookieHandler());
    }

    public void start(Scx scx) {
        AuthModule.init(scx);
        ((BaseAuthHandler)ScxContext.getBean(BaseAuthHandler.class)).readSessionFromFile();
    }

    public void stop(Scx scx) {
        ((BaseAuthHandler)ScxContext.getBean(BaseAuthHandler.class)).writeSessionToFile();
    }

    public String name() {
        return "SCX_EXT-" + super.name();
    }
}

