/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.auth;

import cool.scx.core.base.BaseModelService;
import cool.scx.dao.UpdateFilter;
import cool.scx.enumeration.HttpMethod;
import cool.scx.ext.auth.BaseAuthHandler;
import cool.scx.ext.auth.BaseUser;
import cool.scx.ext.auth.UserInfo;
import cool.scx.ext.auth.annotation.ApiPerms;
import cool.scx.ext.auth.exception.AuthException;
import cool.scx.mvc.annotation.FromBody;
import cool.scx.mvc.annotation.ScxRoute;
import cool.scx.mvc.exception.UnauthorizedException;
import cool.scx.mvc.vo.BaseVo;
import cool.scx.mvc.vo.DataJson;
import cool.scx.mvc.vo.Json;
import io.vertx.ext.web.RoutingContext;

public abstract class BaseAuthApi<T extends BaseUser> {
    protected final BaseAuthHandler<T> authHandler;
    protected final BaseModelService<T> userService;

    protected BaseAuthApi(BaseAuthHandler<T> authHandler, BaseModelService<T> userService) {
        this.authHandler = authHandler;
        this.userService = userService;
    }

    @ScxRoute(methods={HttpMethod.POST})
    public BaseVo login(@FromBody String username, @FromBody String password, RoutingContext ctx) {
        try {
            String token = this.authHandler.login(username, password, ctx);
            return Json.ok().put("token", (Object)token);
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }

    @ScxRoute(methods={HttpMethod.POST})
    public BaseVo loginByThirdParty(@FromBody String uniqueID, @FromBody String accessToken, @FromBody String accountType, RoutingContext ctx) {
        try {
            String token = this.authHandler.loginByThirdParty(uniqueID, accessToken, accountType, ctx);
            return Json.ok().put("token", (Object)token);
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }

    @ScxRoute(methods={HttpMethod.POST})
    public BaseVo signup(@FromBody String username, @FromBody String password) {
        try {
            return DataJson.ok().data(this.authHandler.signup(username, password));
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }

    @ScxRoute(methods={HttpMethod.POST})
    public BaseVo signupByThirdParty(@FromBody String uniqueID, @FromBody String accessToken, @FromBody String accountType) {
        try {
            return DataJson.ok().data(this.authHandler.signupByThirdParty(uniqueID, accessToken, accountType));
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }

    @ScxRoute(methods={HttpMethod.POST})
    public Json logout(RoutingContext routingContext) {
        this.authHandler.logout(routingContext);
        return Json.ok();
    }

    @ApiPerms(checkPerms=false)
    @ScxRoute(methods={HttpMethod.GET})
    public BaseVo info(RoutingContext routingContext) throws UnauthorizedException {
        T user = this.authHandler.getCurrentUser(routingContext);
        return DataJson.ok().data((Object)new UserInfo((BaseUser)((Object)user), this.authHandler.getPerms(user)));
    }

    @ApiPerms(checkPerms=false)
    @ScxRoute(methods={HttpMethod.POST})
    public DataJson changeUserAvatar(@FromBody String newAvatar) throws UnauthorizedException {
        T loginUser = this.authHandler.getCurrentUser();
        ((BaseUser)((Object)loginUser)).avatar = newAvatar;
        return DataJson.ok().data((Object)this.userService.update(loginUser, UpdateFilter.ofIncluded((String[])new String[]{"avatar"})));
    }

    @ApiPerms(checkPerms=false)
    @ScxRoute(methods={HttpMethod.POST})
    public BaseVo changeUsernameBySelf(@FromBody String newUsername, @FromBody String password) throws UnauthorizedException {
        try {
            return DataJson.ok().data(this.authHandler.changeUsernameBySelf(newUsername, password));
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }

    @ApiPerms(checkPerms=false)
    @ScxRoute(methods={HttpMethod.POST})
    public BaseVo changePasswordBySelf(@FromBody String newPassword, @FromBody String oldPassword) throws UnauthorizedException {
        try {
            return DataJson.ok().data(this.authHandler.changePasswordBySelf(newPassword, oldPassword));
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }

    @ApiPerms
    @ScxRoute(methods={HttpMethod.PUT})
    public BaseVo changePasswordByAdmin(@FromBody String newPassword, @FromBody Long userID) {
        try {
            return DataJson.ok().data(this.authHandler.changePasswordByAdmin(newPassword, userID));
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }
}

