/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.auth;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.core.ScxContext;
import cool.scx.core.base.BaseModel;
import cool.scx.core.base.BaseModelService;
import cool.scx.dao.Query;
import cool.scx.dao.SelectFilter;
import cool.scx.dao.UpdateFilter;
import cool.scx.dao.where.WhereOption;
import cool.scx.ext.auth.AuthHelper;
import cool.scx.ext.auth.BaseUser;
import cool.scx.ext.auth.DeviceType;
import cool.scx.ext.auth.LoggedInClient;
import cool.scx.ext.auth.LoggedInClientTable;
import cool.scx.ext.auth.Perms;
import cool.scx.ext.auth.ThirdPartyLoginHandler;
import cool.scx.ext.auth.exception.UnknownLoginHandlerException;
import cool.scx.ext.auth.exception.UnknownUserException;
import cool.scx.ext.auth.exception.UsernameAlreadyExistsException;
import cool.scx.ext.auth.exception.WrongPasswordException;
import cool.scx.ext.ws.WSMessage;
import cool.scx.mvc.ScxMvc;
import cool.scx.mvc.exception.ForbiddenException;
import cool.scx.mvc.exception.UnauthorizedException;
import cool.scx.util.CryptoUtils;
import cool.scx.util.ObjectUtils;
import cool.scx.util.StringUtils;
import cool.scx.util.ansi.Ansi;
import cool.scx.util.ansi.AnsiElement;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.ext.web.RoutingContext;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseAuthHandler<U extends BaseUser> {
    public static final Path SCX_SESSION_CACHE_PATH = ScxContext.getPathByAppRoot((String)"AppRoot:scx-session.cache");
    public static final String SCX_AUTH_TOKEN_KEY = "S-Token";
    public static final String SCX_AUTH_DEVICE_KEY = "S-Device";
    protected final LoggedInClientTable LOGGED_IN_CLIENT_TABLE = new LoggedInClientTable();
    protected final Map<String, ThirdPartyLoginHandler<?>> THIRD_PARTY_LOGIN_HANDLER_MAP = new HashMap();
    protected final BaseModelService<U> userService;

    protected BaseAuthHandler(BaseModelService<U> userService) {
        this.userService = userService;
    }

    public U getCurrentUser() {
        return this.getCurrentUser(ScxMvc.routingContext());
    }

    public U getCurrentUser(RoutingContext ctx) {
        return this.getCurrentUserByToken(AuthHelper.getToken(ctx));
    }

    public U getCurrentUserByToken(String token) {
        LoggedInClient client = this.LOGGED_IN_CLIENT_TABLE.getByToken(token);
        return (U)((Object)(client != null ? (BaseUser)this.userService.get(client.userID.longValue()) : null));
    }

    public String login(String username, String password, RoutingContext ctx) {
        DeviceType loginDevice = AuthHelper.getDeviceTypeByHeader(ctx);
        String token = AuthHelper.tryGetAuthToken(ctx, loginDevice);
        U loginUser = this.tryLogin(username, password);
        this.LOGGED_IN_CLIENT_TABLE.add(new LoggedInClient(token, ((BaseUser)((Object)loginUser)).id, loginDevice));
        return token;
    }

    public U tryLogin(String username, String password) throws UnknownUserException, WrongPasswordException {
        BaseUser needLoginUser = (BaseUser)this.userService.get(new Query().equal("username", (Object)username, new WhereOption[0]));
        if (needLoginUser == null) {
            throw new UnknownUserException();
        }
        boolean b = AuthHelper.checkPassword(password, needLoginUser.password);
        if (!b) {
            throw new WrongPasswordException();
        }
        return (U)((Object)needLoginUser);
    }

    public abstract U signup(String var1, String var2);

    public boolean logout(RoutingContext context) {
        return this.LOGGED_IN_CLIENT_TABLE.removeByToken(AuthHelper.getToken(context));
    }

    public U changePasswordByAdmin(String newPassword, Long id) {
        U loginUser = this.getCurrentUser();
        if (loginUser == null) {
            throw new UnauthorizedException("\u8bf7\u767b\u5f55 !!!");
        }
        if (!((BaseUser)((Object)loginUser)).isAdmin.booleanValue()) {
            throw new ForbiddenException("\u975e\u7ba1\u7406\u5458\u65e0\u6743\u9650\u4fee\u6539\u7528\u6237\u7684\u7528\u6237\u540d !!!");
        }
        BaseUser needChangeUser = (BaseUser)this.userService.get(id.longValue());
        if (needChangeUser == null) {
            throw new UnknownUserException();
        }
        if (StringUtils.isBlank((String)newPassword)) {
            throw new IllegalArgumentException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        needChangeUser.password = CryptoUtils.encryptPassword((String)newPassword.trim());
        return (U)((Object)((BaseUser)this.userService.update((BaseModel)needChangeUser, UpdateFilter.ofIncluded((String[])new String[]{"password"}))));
    }

    public U changePasswordBySelf(String newPassword, String oldPassword) {
        U loginUser = this.getCurrentUser();
        if (loginUser == null) {
            throw new UnauthorizedException("\u8bf7\u767b\u5f55 !!!");
        }
        boolean b = AuthHelper.checkPassword(oldPassword, ((BaseUser)((Object)loginUser)).password);
        if (!b) {
            throw new WrongPasswordException();
        }
        BaseUser needChangeUser = (BaseUser)this.userService.get(((BaseUser)((Object)loginUser)).id.longValue());
        if (needChangeUser == null) {
            throw new UnknownUserException();
        }
        if (StringUtils.isBlank((String)newPassword)) {
            throw new IllegalArgumentException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        needChangeUser.password = CryptoUtils.encryptPassword((String)newPassword.trim());
        return (U)((Object)((BaseUser)this.userService.update((BaseModel)needChangeUser)));
    }

    public U changeUsernameBySelf(String newUsername, String password) {
        U loginUser = this.getCurrentUser();
        if (loginUser == null) {
            throw new UnauthorizedException("\u8bf7\u767b\u5f55 !!!");
        }
        boolean b = AuthHelper.checkPassword(password, ((BaseUser)((Object)loginUser)).password);
        if (!b) {
            throw new WrongPasswordException();
        }
        U needChangeUser = this.checkNeedChangeUserByID(((BaseUser)((Object)loginUser)).id);
        ((BaseUser)((Object)needChangeUser)).username = this.checkNewUsername(newUsername, ((BaseUser)((Object)needChangeUser)).id);
        return (U)((Object)((BaseUser)this.userService.update(needChangeUser)));
    }

    public U checkNeedChangeUserByID(Long id) {
        BaseUser needChangeUser = (BaseUser)this.userService.get(id.longValue(), (SelectFilter)SelectFilter.ofIncluded().addIncluded(new String[]{"id", "password", "username"}));
        if (needChangeUser == null) {
            throw new UnknownUserException();
        }
        return (U)((Object)needChangeUser);
    }

    public final Perms getPerms() {
        return this.getPerms(this.getCurrentUser());
    }

    public abstract Perms getPerms(U var1);

    public abstract U signupByThirdParty(String var1, String var2, String var3);

    public String loginByThirdParty(String uniqueID, String accessToken, String accountType, RoutingContext ctx) {
        DeviceType loginDevice = AuthHelper.getDeviceTypeByHeader(ctx);
        String token = AuthHelper.tryGetAuthToken(ctx, loginDevice);
        U loginUser = this.findThirdPartyLoginHandler(accountType).tryLogin(uniqueID, accessToken);
        this.LOGGED_IN_CLIENT_TABLE.add(new LoggedInClient(token, ((BaseUser)((Object)loginUser)).id, loginDevice));
        return token;
    }

    public final ThirdPartyLoginHandler<U> findThirdPartyLoginHandler(String type) {
        ThirdPartyLoginHandler<?> thirdPartyLoginHandler = this.THIRD_PARTY_LOGIN_HANDLER_MAP.get(type);
        if (thirdPartyLoginHandler == null) {
            throw new UnknownLoginHandlerException();
        }
        return thirdPartyLoginHandler;
    }

    public final LoggedInClientTable loggedInClientTable() {
        return this.LOGGED_IN_CLIENT_TABLE;
    }

    public final void addThirdPartyLoginHandler(String type, ThirdPartyLoginHandler<?> thirdPartyLoginHandler) {
        this.THIRD_PARTY_LOGIN_HANDLER_MAP.put(type, thirdPartyLoginHandler);
    }

    public abstract boolean hasPerm(String var1);

    public void bindWebSocketByToken(WSMessage<?> wsParam) {
        Map objectMap = (Map)ObjectUtils.convertValue(wsParam.body(), (TypeReference)ObjectUtils.MAP_TYPE, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
        String token = (String)ObjectUtils.convertValue(objectMap.get("token"), String.class, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
        LoggedInClient client = this.LOGGED_IN_CLIENT_TABLE.getByToken(token);
        if (client != null) {
            client.webSocket = wsParam.webSocket();
        }
    }

    public LoggedInClient getCurrentClient() {
        return this.LOGGED_IN_CLIENT_TABLE.getByToken(AuthHelper.getToken(ScxMvc.routingContext()));
    }

    public U getCurrentUserByWebSocket(ServerWebSocket socket) {
        LoggedInClient client = this.LOGGED_IN_CLIENT_TABLE.getByWebSocket(socket);
        return (U)((Object)(client != null ? (BaseUser)this.userService.get(client.userID.longValue()) : null));
    }

    public void readSessionFromFile() {
        try {
            byte[] data = Files.readAllBytes(SCX_SESSION_CACHE_PATH);
            byte[] jsonBytes = CryptoUtils.decryptBinary((byte[])data, (String)ScxContext.appKey());
            JsonNode clients = ObjectUtils.jsonMapper((ObjectUtils.Option[])new ObjectUtils.Option[0]).readTree(jsonBytes);
            int i = 0;
            for (JsonNode client : clients) {
                try {
                    this.LOGGED_IN_CLIENT_TABLE.add(new LoggedInClient(client.get("token").textValue(), client.get("userID").longValue(), DeviceType.of(client.get("loginDevice").textValue())));
                    ++i;
                }
                catch (Exception exception) {}
            }
            Ansi.out().brightGreen((Object)("\u6210\u529f\u4ece " + SCX_SESSION_CACHE_PATH + " \u4e2d\u6062\u590d " + i + " \u6761 Session \u6570\u636e!!!"), new AnsiElement[0]).println();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeSessionToFile() {
        List<HashMap> list = this.LOGGED_IN_CLIENT_TABLE.loggedInClients().stream().map(c -> {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("userID", c.userID);
            m.put("loginDevice", (Object)c.loginDevice);
            m.put("token", c.token);
            return m;
        }).toList();
        try {
            byte[] jsonBytes = ObjectUtils.toJson(list, (ObjectUtils.Option[])new ObjectUtils.Option[0]).getBytes(StandardCharsets.UTF_8);
            Files.write(SCX_SESSION_CACHE_PATH, CryptoUtils.encryptBinary((byte[])jsonBytes, (String)ScxContext.appKey()), new OpenOption[0]);
            Ansi.out().red((Object)("\u4fdd\u5b58 " + list.size() + " \u6761 Session \u6570\u636e\u5230 " + SCX_SESSION_CACHE_PATH + " \u4e2d!!!"), new AnsiElement[0]).println();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String checkNewUsername(String username, Long id) {
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("\u65b0\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        username = username.trim();
        long count = this.userService.count(new Query().equal("username", (Object)username, new WhereOption[0]).notEqual("id", (Object)id, new WhereOption[]{WhereOption.SKIP_IF_NULL}));
        if (count != 0L) {
            throw new UsernameAlreadyExistsException();
        }
        return username;
    }

    public String checkNewUsername(String username) {
        return this.checkNewUsername(username, null);
    }
}

