/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.auth;

import cool.scx.ext.auth.DeviceType;
import cool.scx.ext.auth.LoggedInClient;
import io.vertx.core.http.ServerWebSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class LoggedInClientTable {
    private final List<LoggedInClient> list = new ArrayList<LoggedInClient>();

    public void add(LoggedInClient ... loggedInClients) {
        Collections.addAll(this.list, loggedInClients);
    }

    public void addAll(Collection<LoggedInClient> loggedInClients) {
        this.list.addAll(loggedInClients);
    }

    public List<LoggedInClient> getByUserID(Long userID) {
        return this.list.stream().filter(c -> Objects.equals(c.userID, userID)).toList();
    }

    public List<LoggedInClient> getByLoginDevice(DeviceType deviceType) {
        return this.list.stream().filter(c -> Objects.equals((Object)c.loginDevice, (Object)deviceType)).toList();
    }

    public LoggedInClient getByToken(String token) {
        return this.list.stream().filter(c -> Objects.equals(c.token, token)).findAny().orElse(null);
    }

    public boolean removeByUserID(Long userID) {
        return this.list.removeIf(c -> Objects.equals(c.userID, userID));
    }

    public boolean removeByLoginDevice(DeviceType deviceType) {
        return this.list.removeIf(c -> Objects.equals((Object)c.loginDevice, (Object)deviceType));
    }

    public boolean removeByToken(String token) {
        return this.list.removeIf(c -> Objects.equals(c.token, token));
    }

    public LoggedInClient getByWebSocket(ServerWebSocket webSocket) {
        return this.list.stream().filter(c -> Objects.equals(c.webSocket, webSocket)).findAny().orElse(null);
    }

    public boolean removeByWebSocket(ServerWebSocket webSocket) {
        return this.list.removeIf(c -> Objects.equals(c.webSocket, webSocket));
    }

    public List<LoggedInClient> loggedInClients() {
        return new ArrayList<LoggedInClient>(this.list);
    }
}

