/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.ws;

import cool.scx.core.eventbus.ZeroCopyMessageCodec;
import cool.scx.ext.ws.WSMessage;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.http.ServerWebSocket;
import java.util.Collection;
import java.util.function.Consumer;

public class WSEventBus {
    private final EventBus vertxEventBus = WSEventBus.initVertxEventBus();

    private static EventBus initVertxEventBus() {
        return Vertx.vertx().eventBus().registerCodec((MessageCodec)ZeroCopyMessageCodec.DEFAULT_INSTANCE);
    }

    public WSEventBus wsPublish(String address, Object body, Collection<ServerWebSocket> sockets) {
        return this.wsPublish(new WSMessage<Object>(address, body), sockets);
    }

    public WSEventBus wsPublish(WSMessage<?> wsMessage, Collection<ServerWebSocket> sockets) {
        String json = wsMessage.toJson();
        for (ServerWebSocket socket : sockets) {
            if (socket == null || socket.isClosed()) continue;
            socket.writeTextMessage(json);
        }
        return this;
    }

    public WSEventBus wsPublish(String address, Object body, ServerWebSocket ... sockets) {
        return this.wsPublish(new WSMessage<Object>(address, body), sockets);
    }

    public WSEventBus wsPublish(WSMessage<?> wsMessage, ServerWebSocket ... sockets) {
        String json = wsMessage.toJson();
        for (ServerWebSocket socket : sockets) {
            if (socket == null || socket.isClosed()) continue;
            socket.writeTextMessage(json);
        }
        return this;
    }

    public <T> WSEventBus wsConsumer(String address, Consumer<WSMessage<T>> handler) {
        this.vertxEventBus.consumer(address, c -> handler.accept((WSMessage)c.body()));
        return this;
    }

    void publishByWSMessage(WSMessage<?> wsMessage) {
        this.vertxEventBus.publish(wsMessage.address(), wsMessage, new DeliveryOptions().setCodecName(ZeroCopyMessageCodec.ZERO_COPY_CODEC_NAME));
    }
}

