/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.core.ScxContext;
import cool.scx.core.base.BaseModel;
import cool.scx.enumeration.HttpMethod;
import cool.scx.ext.crud.CRUDApiInfo;
import cool.scx.ext.crud.CRUDApiType;
import cool.scx.ext.crud.CRUDHandler;
import cool.scx.ext.crud.CRUDHelper;
import cool.scx.ext.crud.CRUDListParam;
import cool.scx.ext.crud.CRUDListResult;
import cool.scx.ext.crud.CRUDModule;
import cool.scx.ext.crud.CRUDUpdateParam;
import cool.scx.ext.crud.exception.CRUDApiAlreadyDisableException;
import cool.scx.mvc.annotation.FromBody;
import cool.scx.mvc.annotation.FromPath;
import cool.scx.mvc.annotation.ScxRoute;
import cool.scx.mvc.vo.BaseVo;
import cool.scx.mvc.vo.Data;
import java.util.Map;

@ScxRoute(value="api/crud")
public class CRUDController {
    private final CRUDHandler crudHandler;

    public CRUDController() {
        Class<? extends CRUDHandler> crudHandlerClass = ((CRUDModule)ScxContext.findScxModule(CRUDModule.class)).crudHandlerClass();
        this.crudHandler = (CRUDHandler)ScxContext.getBean(crudHandlerClass);
    }

    private static void checkHasThisApi(String modelName, CRUDApiType apiType) {
        CRUDApiInfo crudApiInfo = CRUDHelper.getCRUDApiInfo(modelName);
        boolean hasThisApi = crudApiInfo.hasThisApi(apiType);
        if (!hasThisApi) {
            throw new CRUDApiAlreadyDisableException(modelName, apiType);
        }
    }

    @ScxRoute(value=":modelName/list", methods={HttpMethod.POST})
    public Data list(@FromPath String modelName, CRUDListParam crudListParam) {
        CRUDController.checkHasThisApi(modelName, CRUDApiType.LIST);
        CRUDListResult crudListResult = this.crudHandler.list(modelName, crudListParam);
        return Data.ok().put("items", crudListResult.list()).put("total", (Object)crudListResult.total());
    }

    @ScxRoute(value=":modelName/:id", methods={HttpMethod.GET})
    public BaseVo info(@FromPath String modelName, @FromPath Long id) {
        CRUDController.checkHasThisApi(modelName, CRUDApiType.INFO);
        BaseModel info = this.crudHandler.info(modelName, id);
        return Data.ok((Object)info);
    }

    @ScxRoute(value=":modelName", methods={HttpMethod.POST})
    public BaseVo add(@FromPath String modelName, @FromBody(useAllBody=true) Map<String, Object> saveModel) {
        CRUDController.checkHasThisApi(modelName, CRUDApiType.ADD);
        BaseModel savedModel = this.crudHandler.add(modelName, saveModel);
        return Data.ok((Object)savedModel);
    }

    @ScxRoute(value=":modelName", methods={HttpMethod.PUT})
    public BaseVo update(@FromPath String modelName, CRUDUpdateParam crudUpdateParam) {
        CRUDController.checkHasThisApi(modelName, CRUDApiType.UPDATE);
        BaseModel updatedModel = this.crudHandler.update(modelName, crudUpdateParam);
        return Data.ok((Object)updatedModel);
    }

    @ScxRoute(value=":modelName/:id", methods={HttpMethod.DELETE})
    public BaseVo delete(@FromPath String modelName, @FromPath Long id) {
        CRUDController.checkHasThisApi(modelName, CRUDApiType.DELETE);
        boolean b = this.crudHandler.delete(modelName, id);
        return b ? Data.ok() : Data.fail();
    }

    @ScxRoute(value=":modelName/batch-delete", methods={HttpMethod.DELETE})
    public BaseVo batchDelete(@FromPath String modelName, @FromBody long[] deleteIDs) {
        CRUDController.checkHasThisApi(modelName, CRUDApiType.BATCH_DELETE);
        long deletedCount = this.crudHandler.batchDelete(modelName, deleteIDs);
        return Data.ok().put("deletedCount", (Object)deletedCount);
    }

    @ScxRoute(value=":modelName/check-unique/:fieldName", methods={HttpMethod.POST})
    public BaseVo checkUnique(@FromPath String modelName, @FromPath String fieldName, @FromBody Object value, @FromBody(required=false) Long id) {
        CRUDController.checkHasThisApi(modelName, CRUDApiType.CHECK_UNIQUE);
        boolean isUnique = this.crudHandler.checkUnique(modelName, fieldName, value, id);
        return Data.ok().put("isUnique", (Object)isUnique);
    }
}

