/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.core.base.BaseModel;
import cool.scx.ext.crud.CRUDApiType;
import cool.scx.ext.crud.annotation.UseCRUDApi;

public final class CRUDApiInfo {
    public final Class<BaseModel> baseModelClass;
    public final String baseModelName;
    public final boolean list;
    public final boolean info;
    public final boolean add;
    public final boolean update;
    public final boolean delete;
    public final boolean batchDelete;
    public final boolean checkUnique;

    public CRUDApiInfo(UseCRUDApi useCRUDApi, Class<BaseModel> baseModelClass) {
        this.baseModelClass = baseModelClass;
        this.baseModelName = baseModelClass.getSimpleName().toLowerCase();
        this.list = useCRUDApi.list();
        this.info = useCRUDApi.info();
        this.add = useCRUDApi.add();
        this.update = useCRUDApi.update();
        this.delete = useCRUDApi.delete();
        this.batchDelete = useCRUDApi.batchDelete();
        this.checkUnique = useCRUDApi.checkUnique();
    }

    public boolean hasThisApi(CRUDApiType crudApiType) {
        return switch (crudApiType) {
            default -> throw new IncompatibleClassChangeError();
            case CRUDApiType.LIST -> this.list;
            case CRUDApiType.INFO -> this.info;
            case CRUDApiType.ADD -> this.add;
            case CRUDApiType.UPDATE -> this.update;
            case CRUDApiType.DELETE -> this.delete;
            case CRUDApiType.BATCH_DELETE -> this.batchDelete;
            case CRUDApiType.CHECK_UNIQUE -> this.checkUnique;
        };
    }
}

