/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.fss;

import cool.scx.core.annotation.ScxService;
import cool.scx.core.base.BaseModelService;
import cool.scx.data.Query;
import cool.scx.data.query.OrderByOption;
import cool.scx.data.query.WhereOption;
import cool.scx.ext.fss.FSSConfig;
import cool.scx.ext.fss.FSSObject;
import cool.scx.util.FileUtils;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.List;

@ScxService
public class FSSObjectService
extends BaseModelService<FSSObject> {
    public static Path getPhysicalFilePath(FSSObject fssObject) {
        return Path.of(FSSConfig.uploadFilePath().toString(), fssObject.filePath);
    }

    public List<FSSObject> findFSSObjectListByMD5(String fileMD5) {
        return this.list(new Query().equal("fileMD5", (Object)fileMD5, new WhereOption[0]).desc("uploadTime", new OrderByOption[0]));
    }

    public long countByMD5(String fileMD5) {
        return this.count(new Query().equal("fileMD5", (Object)fileMD5, new WhereOption[0]));
    }

    public FSSObject findByFSSObjectID(String fssObjectID) {
        return (FSSObject)this.get(new Query().equal("fssObjectID", (Object)fssObjectID, new WhereOption[0]));
    }

    public List<FSSObject> findByFSSObjectIDs(List<String> fssObjectIDs) {
        return this.list(new Query().in("fssObjectID", fssObjectIDs, new WhereOption[0]));
    }

    public void delete(String fssObjectID) throws IOException {
        FSSObject needDeleteFile = this.findByFSSObjectID(fssObjectID);
        if (needDeleteFile != null) {
            long count = this.countByMD5(needDeleteFile.fileMD5);
            if (count <= 1L) {
                Path filePath = FSSObjectService.getPhysicalFilePath(needDeleteFile);
                try {
                    FileUtils.delete((Path)filePath.getParent(), (FileUtils.DeleteOption[])new FileUtils.DeleteOption[0]);
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
            }
            this.delete(new long[]{needDeleteFile.id});
        }
    }
}

