/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.common.field_filter.FieldFilter;
import cool.scx.common.standard.HttpMethod;
import cool.scx.core.ScxContext;
import cool.scx.core.base.BaseModel;
import cool.scx.core.base.BaseModelService;
import cool.scx.data.Query;
import cool.scx.data.QueryBuilder;
import cool.scx.data.query.WhereBodySet;
import cool.scx.data.query.WhereOption;
import cool.scx.ext.crud.CRUDHelper;
import cool.scx.ext.crud.CRUDListParam;
import cool.scx.ext.crud.CRUDListParamNew;
import cool.scx.ext.crud.CRUDUpdateParam;
import cool.scx.web.annotation.FromBody;
import cool.scx.web.annotation.FromPath;
import cool.scx.web.annotation.ScxRoute;
import cool.scx.web.vo.BaseVo;
import cool.scx.web.vo.Result;
import java.util.List;
import java.util.Map;

public class BaseCRUDController<T extends BaseModelService> {
    protected final T service;

    public BaseCRUDController(T service) {
        this.service = service;
    }

    public BaseCRUDController() {
        this.service = (BaseModelService)ScxContext.getBean(CRUDHelper.findBaseModelServiceClass(this.getClass()));
    }

    @ScxRoute(methods={HttpMethod.POST})
    public BaseVo list(CRUDListParam crudListParam) {
        Query query = crudListParam.getQueryOrThrow(this.service.entityClass());
        FieldFilter selectFilter = crudListParam.getSelectFilterOrThrow(this.service.entityClass(), this.service.dao().tableInfo());
        List list = this.service.find(query, selectFilter);
        long total = this.service.count(query);
        return Result.ok().put("items", (Object)list).put("total", (Object)total);
    }

    @ScxRoute(methods={HttpMethod.POST})
    public BaseVo listNew(CRUDListParamNew crudListParam) {
        Query query = crudListParam.getQuery();
        FieldFilter selectFilter = crudListParam.getFieldFilter();
        List list = this.service.find(query, selectFilter);
        long total = this.service.count(query);
        return Result.ok().put("items", (Object)list).put("total", (Object)total);
    }

    @ScxRoute(value=":id", methods={HttpMethod.GET})
    public BaseVo info(@FromPath Long id) {
        BaseModel info = this.service.get(id.longValue());
        return Result.ok((Object)info);
    }

    @ScxRoute(value="", methods={HttpMethod.POST})
    public BaseVo add(@FromBody(useAllBody=true) Map<String, Object> saveModel) {
        Object realObject = CRUDHelper.mapToBaseModel(saveModel, this.service.entityClass());
        BaseModel savedModel = this.service.add(realObject);
        return Result.ok((Object)savedModel);
    }

    @ScxRoute(value="", methods={HttpMethod.PUT})
    public BaseVo update(CRUDUpdateParam crudUpdateParam) {
        Object realObject = crudUpdateParam.getBaseModel(this.service.entityClass());
        FieldFilter updateFilter = crudUpdateParam.getUpdateFilter(this.service.entityClass(), this.service.dao().tableInfo());
        BaseModel updatedModel = this.service.update(realObject, updateFilter);
        return Result.ok((Object)updatedModel);
    }

    @ScxRoute(value=":id", methods={HttpMethod.DELETE})
    public BaseVo delete(@FromPath Long id) {
        boolean b = this.service.delete(new long[]{id}) == 1L;
        return b ? Result.ok() : Result.fail();
    }

    @ScxRoute(methods={HttpMethod.DELETE})
    public BaseVo batchDelete(@FromBody long[] deleteIDs) {
        long deletedCount = this.service.delete(deleteIDs);
        return Result.ok().put("deletedCount", (Object)deletedCount);
    }

    @ScxRoute(value="check-unique/:fieldName", methods={HttpMethod.POST})
    public BaseVo checkUnique(@FromPath String fieldName, @FromBody Object value, @FromBody(required=false) Long id) {
        CRUDHelper.checkFieldName(this.service.entityClass(), fieldName);
        WhereBodySet query = QueryBuilder.andSet().eq(fieldName, value, new WhereOption[0]).ne("id", (Object)id, new WhereOption[]{WhereOption.SKIP_IF_NULL});
        boolean isUnique = this.service.count((Query)query) == 0L;
        return Result.ok().put("isUnique", (Object)isUnique);
    }
}

