/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.fss;

import cool.scx.common.util.FileUtils;
import cool.scx.core.annotation.ScxService;
import cool.scx.core.base.BaseModelService;
import cool.scx.data.query.Query;
import cool.scx.data.query.QueryBuilder;
import cool.scx.data.query.QueryOption;
import cool.scx.ext.fss.FSSHelper;
import cool.scx.ext.fss.FSSObject;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.List;

@ScxService
public class FSSObjectService
extends BaseModelService<FSSObject> {
    public List<FSSObject> findFSSObjectListByHash(String fileHash) {
        return this.find(QueryBuilder.query().where(new Object[]{QueryBuilder.eq((String)"fileHash", (Object)fileHash, (QueryOption[])new QueryOption[0])}).orderBy(new Object[]{QueryBuilder.desc((String)"uploadTime", (QueryOption[])new QueryOption[0])}));
    }

    public long countByHash(String fileHash) {
        return this.count(QueryBuilder.query().where(new Object[]{QueryBuilder.eq((String)"fileHash", (Object)fileHash, (QueryOption[])new QueryOption[0])}));
    }

    public FSSObject findByFSSObjectID(String fssObjectID) {
        return (FSSObject)this.get(QueryBuilder.query().where(new Object[]{QueryBuilder.eq((String)"fssObjectID", (Object)fssObjectID, (QueryOption[])new QueryOption[0])}));
    }

    public List<FSSObject> findByFSSObjectIDs(List<String> fssObjectIDs) {
        return this.find((Query)QueryBuilder.in((String)"fssObjectID", fssObjectIDs, (QueryOption[])new QueryOption[0]));
    }

    public void delete(String fssObjectID) throws IOException {
        FSSObject needDeleteFile = this.findByFSSObjectID(fssObjectID);
        if (needDeleteFile != null) {
            long count = this.countByHash(needDeleteFile.fileHash);
            if (count <= 1L) {
                Path filePath = FSSHelper.getPhysicalFilePath(needDeleteFile);
                try {
                    FileUtils.delete((Path)filePath.getParent());
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
            }
            this.delete(new long[]{needDeleteFile.id});
        }
    }
}

