/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.static_server;

import cool.scx.common.util.ScxExceptionHelper;
import cool.scx.config.ScxConfigValueHandler;
import cool.scx.core.Scx;
import cool.scx.core.ScxModule;
import cool.scx.ext.static_server.ConvertStaticServerHandler;
import cool.scx.ext.static_server.SingleFileStaticHandler;
import cool.scx.ext.static_server.StaticServer;
import io.vertx.core.Handler;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.FileSystemAccess;
import io.vertx.ext.web.handler.StaticHandler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.stream.Collectors;

public class StaticServerModule
extends ScxModule {
    private static final System.Logger logger = System.getLogger(StaticServerModule.class.getName());

    private static void registerStaticServerHandler(Router vertxRouter, List<StaticServer> staticServers) {
        for (StaticServer staticServer : staticServers) {
            Boolean isRegularFile = (Boolean)ScxExceptionHelper.ignore(() -> Files.isRegularFile(staticServer.root(), new LinkOption[0]), (Object)true);
            if (isRegularFile.booleanValue()) {
                vertxRouter.route(staticServer.location()).handler((Handler)new SingleFileStaticHandler(staticServer.root()));
                continue;
            }
            vertxRouter.route(staticServer.location()).handler((Handler)StaticHandler.create((FileSystemAccess)FileSystemAccess.ROOT, (String)staticServer.root().toString()).setFilesReadOnly(false));
        }
    }

    public void start(Scx scx) {
        List staticServers = (List)scx.scxConfig().get("static-servers", (ScxConfigValueHandler)new ConvertStaticServerHandler(scx.scxEnvironment()));
        logger.log(System.Logger.Level.DEBUG, "\u9759\u6001\u8d44\u6e90\u670d\u52a1\u5668 -->  {0}", staticServers.stream().map(StaticServer::location).collect(Collectors.joining(", ", "[", "]")));
        StaticServerModule.registerStaticServerHandler((Router)scx.scxHttpRouter(), staticServers);
    }

    public String name() {
        return "SCX_EXT-" + super.name();
    }
}

