/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.fss;

import cool.scx.common.util.FileUtils;
import cool.scx.common.util.RandomUtils;
import cool.scx.ext.fss.FSSConfig;
import cool.scx.ext.fss.FSSObject;
import cool.scx.http.exception.NotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import net.coobird.thumbnailator.geometry.Positions;

public final class FSSHelper {
    private static final Map<String, Positions> TYPE_POSITIONS_MAP = new HashMap<String, Positions>();

    public static Positions getPositions(String type) {
        if (type == null) {
            return null;
        }
        return TYPE_POSITIONS_MAP.get(type.toLowerCase());
    }

    public static Path getPhysicalFilePath(FSSObject fssObject) {
        return Path.of(FSSConfig.uploadFilePath().toString(), fssObject.filePath);
    }

    public static Path checkPhysicalFile(FSSObject fssObject) throws NotFoundException {
        Path physicalFile = FSSHelper.getPhysicalFilePath(fssObject);
        if (Files.notExists(physicalFile, new LinkOption[0])) {
            throw new NotFoundException();
        }
        return physicalFile;
    }

    public static Path getUploadTempPath(String fileHash) {
        return FSSConfig.uploadFilePath().resolve("TEMP").resolve(fileHash);
    }

    public static FSSObject copyFSSObject(String fileName, FSSObject oldFSSObject) {
        FSSObject fssObject = new FSSObject();
        fssObject.fssObjectID = RandomUtils.randomUUID();
        fssObject.fileName = fileName;
        fssObject.uploadTime = LocalDateTime.now();
        fssObject.filePath = oldFSSObject.filePath;
        fssObject.fileSizeDisplay = oldFSSObject.fileSizeDisplay;
        fssObject.fileSize = oldFSSObject.fileSize;
        fssObject.fileHash = oldFSSObject.fileHash;
        fssObject.fileExtension = FileUtils.getExtension((String)fssObject.fileName);
        return fssObject;
    }

    public static FSSObject createFSSObjectByFileInfo(String fileName, Long fileSize, String fileHash) {
        LocalDateTime now = LocalDateTime.now();
        String yearStr = String.valueOf(now.getYear());
        String monthStr = String.valueOf(now.getMonthValue());
        String dayStr = String.valueOf(now.getDayOfMonth());
        FSSObject fssObject = new FSSObject();
        fssObject.fssObjectID = RandomUtils.randomUUID();
        fssObject.fileName = fileName;
        fssObject.uploadTime = now;
        fssObject.fileSizeDisplay = FileUtils.longToDisplaySize((long)fileSize);
        fssObject.fileSize = fileSize;
        fssObject.fileHash = fileHash;
        fssObject.fileExtension = FileUtils.getExtension((String)fssObject.fileName);
        fssObject.filePath = new String[]{yearStr, monthStr, dayStr, fileHash, fileName};
        return fssObject;
    }

    public static Integer getLastUploadChunk(Path uploadConfigFile, Integer chunkLength) throws IOException {
        try {
            String allStr = Files.readString(uploadConfigFile);
            return Integer.parseInt(allStr.split("_")[0]);
        }
        catch (Exception e) {
            FSSHelper.updateLastUploadChunk(uploadConfigFile, -1, chunkLength);
            return -1;
        }
    }

    public static void updateLastUploadChunk(Path uploadConfigFile, Integer nowChunkIndex, Integer chunkLength) throws IOException {
        String str = nowChunkIndex + "_" + chunkLength;
        FileUtils.write((Path)uploadConfigFile, (byte[])str.getBytes(StandardCharsets.UTF_8), (OpenOption[])new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.SYNC, StandardOpenOption.WRITE});
    }

    static {
        TYPE_POSITIONS_MAP.put("top-left", Positions.TOP_LEFT);
        TYPE_POSITIONS_MAP.put("top-center", Positions.TOP_CENTER);
        TYPE_POSITIONS_MAP.put("top-right", Positions.TOP_RIGHT);
        TYPE_POSITIONS_MAP.put("center-left", Positions.CENTER_LEFT);
        TYPE_POSITIONS_MAP.put("center", Positions.CENTER);
        TYPE_POSITIONS_MAP.put("center-center", Positions.CENTER);
        TYPE_POSITIONS_MAP.put("center-right", Positions.CENTER_RIGHT);
        TYPE_POSITIONS_MAP.put("bottom-left", Positions.BOTTOM_LEFT);
        TYPE_POSITIONS_MAP.put("bottom-center", Positions.BOTTOM_CENTER);
        TYPE_POSITIONS_MAP.put("bottom-right", Positions.BOTTOM_RIGHT);
        TYPE_POSITIONS_MAP.put("tl", Positions.TOP_LEFT);
        TYPE_POSITIONS_MAP.put("tc", Positions.TOP_CENTER);
        TYPE_POSITIONS_MAP.put("tr", Positions.TOP_RIGHT);
        TYPE_POSITIONS_MAP.put("cl", Positions.CENTER_LEFT);
        TYPE_POSITIONS_MAP.put("c", Positions.CENTER);
        TYPE_POSITIONS_MAP.put("cc", Positions.CENTER);
        TYPE_POSITIONS_MAP.put("cr", Positions.CENTER_RIGHT);
        TYPE_POSITIONS_MAP.put("bl", Positions.BOTTOM_LEFT);
        TYPE_POSITIONS_MAP.put("bc", Positions.BOTTOM_CENTER);
        TYPE_POSITIONS_MAP.put("br", Positions.BOTTOM_RIGHT);
    }
}

