/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.core.base.BaseModel;
import cool.scx.data.field_filter.FieldFilter;
import cool.scx.data.field_filter.FieldFilterBuilder;
import cool.scx.data.jdbc.AnnotationConfigTable;
import cool.scx.data.jdbc.JDBCDaoHelper;
import cool.scx.ext.crud.CRUDHelper;
import cool.scx.ext.crud.exception.EmptyUpdateColumnException;
import java.util.Arrays;
import java.util.Map;

public final class CRUDUpdateParam {
    public Map<String, Object> updateModel;
    public String[] needUpdateFieldNames;

    public <B extends BaseModel> B getBaseModel(Class<B> modelClass) {
        return CRUDHelper.mapToBaseModel(this.updateModel, modelClass);
    }

    public FieldFilter getUpdateFilter(Class<? extends BaseModel> modelClass, AnnotationConfigTable scxDaoTableInfo) {
        if (this.needUpdateFieldNames == null) {
            return FieldFilterBuilder.ofExcluded((String[])new String[0]);
        }
        String[] legalFieldName = (String[])Arrays.stream(this.needUpdateFieldNames).map(fieldName -> CRUDHelper.checkFieldName(modelClass, fieldName)).toArray(String[]::new);
        FieldFilter updateFilter = FieldFilterBuilder.ofIncluded((String[])legalFieldName).ignoreNullValue(false);
        if (JDBCDaoHelper.filter((FieldFilter)updateFilter, (AnnotationConfigTable)scxDaoTableInfo).length == 0) {
            throw new EmptyUpdateColumnException();
        }
        return updateFilter;
    }
}

