/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ffm;

import cool.scx.ffm.type.callback.Callback;
import cool.scx.ffm.type.mapper.ByteArrayMapper;
import cool.scx.ffm.type.mapper.CharArrayMapper;
import cool.scx.ffm.type.mapper.DoubleArrayMapper;
import cool.scx.ffm.type.mapper.FloatArrayMapper;
import cool.scx.ffm.type.mapper.IntArrayMapper;
import cool.scx.ffm.type.mapper.LongArrayMapper;
import cool.scx.ffm.type.mapper.Mapper;
import cool.scx.ffm.type.mapper.ShortArrayMapper;
import cool.scx.ffm.type.paramter.ArrayParameter;
import cool.scx.ffm.type.paramter.CallbackParameter;
import cool.scx.ffm.type.paramter.MapperParameter;
import cool.scx.ffm.type.paramter.Parameter;
import cool.scx.ffm.type.paramter.RawValueParameter;
import cool.scx.ffm.type.paramter.StringParameter;
import cool.scx.ffm.type.paramter.StructParameter;
import cool.scx.ffm.type.struct.Struct;
import cool.scx.ffm.type.wrapper.AddressWrapper;
import cool.scx.ffm.type.wrapper.BooleanWrapper;
import cool.scx.ffm.type.wrapper.ByteWrapper;
import cool.scx.ffm.type.wrapper.CharWrapper;
import cool.scx.ffm.type.wrapper.DoubleWrapper;
import cool.scx.ffm.type.wrapper.FloatWrapper;
import cool.scx.ffm.type.wrapper.IntWrapper;
import cool.scx.ffm.type.wrapper.LongWrapper;
import cool.scx.ffm.type.wrapper.ShortWrapper;
import cool.scx.ffm.type.wrapper.Wrapper;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.runtime.SwitchBootstraps;

public final class FFMHelper {
    public static MemoryLayout getMemoryLayout(Class<?> type) {
        if (type == Byte.class || type == Byte.TYPE) {
            return ValueLayout.JAVA_BYTE;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return ValueLayout.JAVA_BOOLEAN;
        }
        if (type == Character.class || type == Character.TYPE) {
            return ValueLayout.JAVA_CHAR;
        }
        if (type == Short.class || type == Short.TYPE) {
            return ValueLayout.JAVA_SHORT;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return ValueLayout.JAVA_INT;
        }
        if (type == Long.class || type == Long.TYPE) {
            return ValueLayout.JAVA_LONG;
        }
        if (type == Float.class || type == Float.TYPE) {
            return ValueLayout.JAVA_FLOAT;
        }
        if (type == Double.class || type == Double.TYPE) {
            return ValueLayout.JAVA_DOUBLE;
        }
        if (type == MemorySegment.class) {
            return ValueLayout.ADDRESS;
        }
        if (ByteWrapper.class.isAssignableFrom(type)) {
            return ValueLayout.JAVA_BYTE;
        }
        if (BooleanWrapper.class.isAssignableFrom(type)) {
            return ValueLayout.JAVA_BOOLEAN;
        }
        if (CharWrapper.class.isAssignableFrom(type)) {
            return ValueLayout.JAVA_CHAR;
        }
        if (ShortWrapper.class.isAssignableFrom(type)) {
            return ValueLayout.JAVA_SHORT;
        }
        if (IntWrapper.class.isAssignableFrom(type)) {
            return ValueLayout.JAVA_INT;
        }
        if (LongWrapper.class.isAssignableFrom(type)) {
            return ValueLayout.JAVA_LONG;
        }
        if (FloatWrapper.class.isAssignableFrom(type)) {
            return ValueLayout.JAVA_FLOAT;
        }
        if (DoubleWrapper.class.isAssignableFrom(type)) {
            return ValueLayout.JAVA_DOUBLE;
        }
        if (AddressWrapper.class.isAssignableFrom(type)) {
            return ValueLayout.ADDRESS;
        }
        if (String.class == type) {
            return ValueLayout.ADDRESS;
        }
        if (Mapper.class.isAssignableFrom(type)) {
            return ValueLayout.ADDRESS;
        }
        if (Struct.class.isAssignableFrom(type)) {
            return ValueLayout.ADDRESS;
        }
        if (Callback.class.isAssignableFrom(type)) {
            return ValueLayout.ADDRESS;
        }
        if (type.isArray() && type.getComponentType().isPrimitive()) {
            return ValueLayout.ADDRESS;
        }
        if (Parameter.class.isAssignableFrom(type)) {
            return ValueLayout.ADDRESS;
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u53c2\u6570\u7c7b\u578b !!! " + String.valueOf(type));
    }

    public static MemoryLayout[] getMemoryLayouts(Class<?>[] types) {
        MemoryLayout[] memoryLayouts = new MemoryLayout[types.length];
        for (int i = 0; i < types.length; ++i) {
            memoryLayouts[i] = FFMHelper.getMemoryLayout(types[i]);
        }
        return memoryLayouts;
    }

    public static Parameter convertToParameter(Object o) throws NoSuchMethodException, IllegalAccessException {
        Parameter parameter;
        Object object = o;
        int n = 0;
        block17: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Boolean.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, MemorySegment.class, Wrapper.class, String.class, Mapper.class, Struct.class, Callback.class, byte[].class, char[].class, short[].class, int[].class, long[].class, float[].class, double[].class, Parameter.class}, (Object)object, n)) {
                case -1: {
                    parameter = new RawValueParameter(MemorySegment.NULL);
                    break block17;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (!(object instanceof Byte || object instanceof Boolean || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof MemorySegment)) {
                        n = 9;
                        continue block17;
                    }
                    parameter = new RawValueParameter(o);
                    break block17;
                }
                case 9: {
                    Wrapper w = (Wrapper)object;
                    parameter = w;
                    break block17;
                }
                case 10: {
                    String s = (String)object;
                    parameter = new StringParameter(s);
                    break block17;
                }
                case 11: {
                    Mapper m = (Mapper)object;
                    parameter = new MapperParameter(m);
                    break block17;
                }
                case 12: {
                    Struct c = (Struct)object;
                    parameter = new StructParameter(c);
                    break block17;
                }
                case 13: {
                    Callback c = (Callback)object;
                    parameter = new CallbackParameter(c);
                    break block17;
                }
                case 14: {
                    byte[] c = (byte[])object;
                    parameter = new ArrayParameter(c, new ByteArrayMapper(c));
                    break block17;
                }
                case 15: {
                    char[] c = (char[])object;
                    parameter = new ArrayParameter(c, new CharArrayMapper(c));
                    break block17;
                }
                case 16: {
                    short[] c = (short[])object;
                    parameter = new ArrayParameter(c, new ShortArrayMapper(c));
                    break block17;
                }
                case 17: {
                    int[] c = (int[])object;
                    parameter = new ArrayParameter(c, new IntArrayMapper(c));
                    break block17;
                }
                case 18: {
                    long[] c = (long[])object;
                    parameter = new ArrayParameter(c, new LongArrayMapper(c));
                    break block17;
                }
                case 19: {
                    float[] c = (float[])object;
                    parameter = new ArrayParameter(c, new FloatArrayMapper(c));
                    break block17;
                }
                case 20: {
                    double[] c = (double[])object;
                    parameter = new ArrayParameter(c, new DoubleArrayMapper(c));
                    break block17;
                }
                case 21: {
                    Parameter r = (Parameter)object;
                    parameter = r;
                    break block17;
                }
                default: {
                    throw new RuntimeException("\u65e0\u6cd5\u8f6c\u6362\u7684\u7c7b\u578b !!! " + String.valueOf(o.getClass()));
                }
            }
            break;
        }
        return parameter;
    }

    public static Parameter[] convertToParameters(Object[] objs) throws NoSuchMethodException, IllegalAccessException {
        Parameter[] result = new Parameter[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            result[i] = FFMHelper.convertToParameter(objs[i]);
        }
        return result;
    }

    public static String toString(char[] buf) {
        int len = buf.length;
        for (int index = 0; index < len; ++index) {
            if (buf[index] != '\u0000') continue;
            len = index;
            break;
        }
        return len == 0 ? "" : new String(buf, 0, len);
    }
}

