/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ffm.platform.win32.helper;

import cool.scx.ffm.platform.win32.User32;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.ArrayList;
import java.util.List;

public class WindowHelper {
    public static List<WindowInfo> FindAllWindow() throws Throwable {
        ArrayList<WindowInfo> list = new ArrayList<WindowInfo>();
        User32.USER32.EnumWindows((hWnd, l) -> {
            if (User32.USER32.GetParent(hWnd).address() == 0L) {
                String title = WindowHelper.getWindowTitle(hWnd);
                String className = WindowHelper.getWindowClassName(hWnd);
                boolean isVisible = User32.USER32.IsWindowVisible(hWnd);
                MemorySegment threadProcessId = User32.USER32.GetWindowThreadProcessId(hWnd, Arena.global().allocate(ValueLayout.JAVA_LONG));
                list.add(new WindowInfo(hWnd, className, title, isVisible, threadProcessId));
            }
            return true;
        }, 0L);
        return list;
    }

    public static String getWindowTitle(MemorySegment hWnd) {
        int l = User32.USER32.GetWindowTextLengthW(hWnd);
        char[] chars = new char[l];
        int l1 = User32.USER32.GetWindowTextW(hWnd, chars, l + 1);
        return new String(chars, 0, l1);
    }

    public static String getWindowClassName(MemorySegment hWnd) {
        char[] chars = new char[512];
        int l1 = User32.USER32.GetClassNameW(hWnd, chars, 512);
        return new String(chars, 0, l1);
    }

    public record WindowInfo(MemorySegment hWnd, String className, String title, boolean isVisible, MemorySegment threadProcessId) {
    }
}

