/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ffm.type.paramter;

import cool.scx.ffm.FFMHelper;
import cool.scx.ffm.type.paramter.Parameter;
import cool.scx.ffm.type.struct.Struct;
import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.FieldInfo;
import cool.scx.reflect.ReflectFactory;
import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.StructLayout;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StructParameter
implements Parameter {
    private final Object value;
    private final Map<FieldInfo, VarHandle> fieldMap;
    private final StructLayout LAYOUT;
    private MemorySegment memorySegment;

    public StructParameter(Struct value) {
        this.value = value;
        ClassInfo classInfo = ReflectFactory.getClassInfo(this.value.getClass());
        this.fieldMap = new HashMap<FieldInfo, VarHandle>();
        List<FieldInfo> field = Arrays.stream(classInfo.fields()).filter(c -> c.accessModifier() == AccessModifier.PUBLIC).toList();
        MemoryLayout[] memoryLayouts = new MemoryLayout[field.size()];
        for (int i = 0; i < field.size(); ++i) {
            FieldInfo f = field.get(i);
            MemoryLayout memoryLayout = FFMHelper.getMemoryLayout(f.type().getRawClass());
            memoryLayouts[i] = memoryLayout.withName(f.name());
        }
        this.LAYOUT = MemoryLayout.structLayout(memoryLayouts);
        for (FieldInfo f : field) {
            VarHandle x = this.LAYOUT.varHandle(MemoryLayout.PathElement.groupElement(f.name()));
            VarHandle ff = MethodHandles.insertCoordinates(x, 1, 0L);
            this.fieldMap.put(f, ff);
        }
    }

    @Override
    public Object toNativeParameter(Arena arena) {
        this.memorySegment = arena.allocate(this.LAYOUT);
        return this.memorySegment;
    }

    @Override
    public void beforeCloseArena() {
        for (Map.Entry<FieldInfo, VarHandle> e : this.fieldMap.entrySet()) {
            FieldInfo k = e.getKey();
            VarHandle v = e.getValue();
            Object o = v.get(this.memorySegment);
            try {
                k.set(this.value, o);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

