/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ffm;

import cool.scx.ffm.FFMHelper;
import cool.scx.ffm.type.paramter.Parameter;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public final class FFMProxy
implements InvocationHandler {
    private final SymbolLookup lookup;
    private final Map<Method, MethodHandle> cache;

    private FFMProxy() {
        this.lookup = Linker.nativeLinker().defaultLookup();
        this.cache = new HashMap<Method, MethodHandle>();
    }

    private FFMProxy(String name) {
        this.lookup = SymbolLookup.libraryLookup(name, Arena.global());
        this.cache = new HashMap<Method, MethodHandle>();
    }

    private FFMProxy(Path path) {
        this.lookup = SymbolLookup.libraryLookup(path, Arena.global());
        this.cache = new HashMap<Method, MethodHandle>();
    }

    public static <T> T ffmProxy(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new FFMProxy());
    }

    public static <T> T ffmProxy(String name, Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new FFMProxy(name));
    }

    public static <T> T ffmProxy(Path path, Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new FFMProxy(path));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, args);
        }
        MethodHandle methodHandle = this.cache.computeIfAbsent(method, this::findMethodHandle);
        try (Arena arena = Arena.ofConfined();){
            Parameter[] parameters = FFMHelper.convertToParameters(args);
            Object[] nativeParameters = new Object[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                nativeParameters[i] = parameters[i].toNativeParameter(arena);
            }
            Object result = methodHandle.invokeWithArguments(nativeParameters);
            for (Parameter parameter : parameters) {
                parameter.beforeCloseArena();
            }
            Object object = result;
            return object;
        }
    }

    private MethodHandle findMethodHandle(Method method) {
        MemorySegment fun = this.lookup.find(method.getName()).orElseThrow();
        MemoryLayout returnLayout = FFMHelper.getMemoryLayout(method.getReturnType());
        MemoryLayout[] paramLayouts = FFMHelper.getMemoryLayouts(method.getParameterTypes());
        FunctionDescriptor functionDescriptor = FunctionDescriptor.of(returnLayout, paramLayouts);
        return Linker.nativeLinker().downcallHandle(fun, functionDescriptor, new Linker.Option[0]);
    }
}

