package cool.scx.ffm.type.mapper;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;

import static java.lang.foreign.ValueLayout.JAVA_DOUBLE;

/**
 * DoubleMapper
 *
 * @author scx567888
 * @version 0.0.1
 */
public class DoubleMapper implements Mapper {

    private double value;

    public DoubleMapper() {
        this.value = 0;
    }

    public DoubleMapper(double value) {
        this.value = value;
    }

    public double getValue() {
        return value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public MemorySegment toMemorySegment(Arena arena) {
        return arena.allocateFrom(JAVA_DOUBLE, this.value);
    }

    @Override
    public Object fromMemorySegment(MemorySegment memorySegment) {
        this.value = memorySegment.get(JAVA_DOUBLE, 0);
        return value;
    }

}
