/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ffm.type.paramter;

import cool.scx.ffm.FFMHelper;
import cool.scx.ffm.type.callback.Callback;
import cool.scx.ffm.type.paramter.Parameter;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ClassInfoFactory;
import cool.scx.reflect.MethodInfo;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Arrays;

public class CallbackParameter
implements Parameter {
    private final Callback callback;
    private final MethodHandle fun;
    private final FunctionDescriptor functionDescriptor;

    public CallbackParameter(Callback callback) throws NoSuchMethodException, IllegalAccessException {
        this.callback = callback;
        String callbackMethodName = callback.callbackMethodName();
        ClassInfo classInfo = ClassInfoFactory.getClassInfo(callback.getClass());
        MethodInfo methodInfo = Arrays.stream(classInfo.methods()).filter(method -> method.name().equals(callbackMethodName)).findFirst().orElseThrow(() -> new NoSuchMethodException(callbackMethodName));
        methodInfo.setAccessible(true);
        Method method2 = methodInfo.method();
        this.fun = MethodHandles.lookup().unreflect(method2).bindTo(callback);
        MemoryLayout r = FFMHelper.getMemoryLayout(method2.getReturnType());
        MemoryLayout[] p = FFMHelper.getMemoryLayouts(method2.getParameterTypes());
        this.functionDescriptor = FunctionDescriptor.of(r, p);
    }

    @Override
    public Object toNativeParameter(Arena arena) {
        return Linker.nativeLinker().upcallStub(this.fun, this.functionDescriptor, arena, new Linker.Option[0]);
    }
}

