/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ffm.platform.win32.helper;

import cool.scx.ffm.platform.win32.Win32Exception;
import cool.scx.ffm.platform.win32.helper.Advapi32Helper;
import java.util.Map;

public final class WindowsProxyHelper {
    public static final String INTERNET_SETTINGS_KEY_PATH = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";
    public static final String PROXY_ENABLE = "ProxyEnable";
    public static final String PROXY_SERVER = "ProxyServer";
    public static final String PROXY_OVERRIDE = "ProxyOverride";
    public static final String LOCAL_HOST = "127.0.0.1";

    public static Map<String, Object> getInternetSettingsValues() {
        return Advapi32Helper.registryGetValues(-2147483647, INTERNET_SETTINGS_KEY_PATH);
    }

    public static Boolean getProxyEnableOrNull() {
        try {
            return WindowsProxyHelper.getProxyEnable();
        }
        catch (Win32Exception e) {
            return null;
        }
    }

    public static Boolean getProxyEnable() {
        int value = Advapi32Helper.registryGetIntValue(-2147483647, INTERNET_SETTINGS_KEY_PATH, PROXY_ENABLE);
        return value == 1;
    }

    public static void setProxyEnabled(boolean enable) {
        Advapi32Helper.registrySetIntValue(-2147483647, INTERNET_SETTINGS_KEY_PATH, PROXY_ENABLE, enable ? 1 : 0);
    }

    public static void enableProxy() {
        WindowsProxyHelper.setProxyEnabled(true);
    }

    public static void disableProxy() {
        WindowsProxyHelper.setProxyEnabled(false);
    }

    public static String getProxyServerOrNull() {
        try {
            return WindowsProxyHelper.getProxyServer();
        }
        catch (Win32Exception e) {
            return null;
        }
    }

    public static String getProxyServer() {
        return Advapi32Helper.registryGetStringValue(-2147483647, INTERNET_SETTINGS_KEY_PATH, PROXY_SERVER);
    }

    public static void setProxyServer(int port) {
        WindowsProxyHelper.setProxyServer("127.0.0.1:" + port);
    }

    public static void setProxyServer(String host) {
        Advapi32Helper.registrySetStringValue(-2147483647, INTERNET_SETTINGS_KEY_PATH, PROXY_SERVER, host);
    }

    public static void clearProxyServer() {
        WindowsProxyHelper.setProxyServer("");
    }

    public static String[] getProxyOverrideOrNull() {
        try {
            return WindowsProxyHelper.getProxyOverride();
        }
        catch (Win32Exception e) {
            return null;
        }
    }

    public static String[] getProxyOverride() {
        String value = Advapi32Helper.registryGetStringValue(-2147483647, INTERNET_SETTINGS_KEY_PATH, PROXY_OVERRIDE);
        return value.split(";");
    }

    public static void setProxyOverride(String ... list) {
        Advapi32Helper.registrySetStringValue(-2147483647, INTERNET_SETTINGS_KEY_PATH, PROXY_OVERRIDE, String.join((CharSequence)";", list));
    }

    public static void clearProxyOverride() {
        WindowsProxyHelper.setProxyOverride(new String[0]);
    }

    public static ProxyInfo getProxyInfo() {
        return new ProxyInfo(WindowsProxyHelper.getProxyServer(), WindowsProxyHelper.getProxyEnable(), WindowsProxyHelper.getProxyOverride());
    }

    public static ProxyInfo getProxyInfoOrNull() {
        return new ProxyInfo(WindowsProxyHelper.getProxyServerOrNull(), WindowsProxyHelper.getProxyEnableOrNull(), WindowsProxyHelper.getProxyOverrideOrNull());
    }

    public static void setProxy(ProxyInfo proxyInfo) {
        if (proxyInfo.proxyServer != null) {
            WindowsProxyHelper.setProxyServer(proxyInfo.proxyServer);
        }
        if (proxyInfo.proxyEnable != null) {
            WindowsProxyHelper.setProxyEnabled(proxyInfo.proxyEnable);
        }
        if (proxyInfo.proxyOverride != null) {
            WindowsProxyHelper.setProxyOverride(proxyInfo.proxyOverride);
        }
    }

    public record ProxyInfo(String proxyServer, Boolean proxyEnable, String[] proxyOverride) {
    }
}

